/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;

public class DelegatingInterceptorInvocationContext
implements InvocationContext {
    private InvocationContext delegateInvocationContext;
    private List<Interceptor> invocationQueue;
    private List<Object> interceptorInstances;
    int position;
    private InterceptionType interceptionType;

    public DelegatingInterceptorInvocationContext(InvocationContext delegateInvocationContext, List<Interceptor<?>> interceptors, List<Object> instances, InterceptionType interceptionType) {
        this.delegateInvocationContext = delegateInvocationContext;
        this.interceptionType = interceptionType;
        this.invocationQueue = new ArrayList(interceptors);
        this.interceptorInstances = new ArrayList<Object>(instances);
        this.position = 0;
    }

    public Map<String, Object> getContextData() {
        return this.delegateInvocationContext.getContextData();
    }

    public Method getMethod() {
        return this.delegateInvocationContext.getMethod();
    }

    public Object[] getParameters() {
        return this.delegateInvocationContext.getParameters();
    }

    public Object getTarget() {
        return this.delegateInvocationContext.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        int oldPosition = this.position;
        try {
            if (this.position < this.invocationQueue.size()) {
                Object interceptorInstance = this.interceptorInstances.get(this.position);
                Object object = this.invocationQueue.get(this.position++).intercept(this.interceptionType, interceptorInstance, (InvocationContext)this);
                return object;
            }
            Object object = this.delegateInvocationContext.proceed();
            return object;
        }
        finally {
            this.position = oldPosition;
        }
    }

    public void setParameters(Object[] params) {
        this.delegateInvocationContext.setParameters(params);
    }

    public Object getTimer() {
        throw new UnsupportedOperationException("Get timer not supported");
    }
}

