/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJBContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.weld.ejb.DelegatingInterceptorInvocationContext;
import org.jboss.as.weld.services.bootstrap.WeldEjbServices;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.base.BaseSessionContext;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;

public class Jsr299BindingsInterceptor
implements Serializable {
    private static final long serialVersionUID = -1999613731498564948L;
    private final Map<String, SerializableContextualInstance<Interceptor<Object>, Object>> interceptorInstances = new ConcurrentHashMap<String, SerializableContextualInstance<Interceptor<Object>, Object>>();
    private volatile String ejbName;
    private volatile CreationalContext<Object> creationalContext;
    @Inject
    private BeanManager beanManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void doPostConstruct(InvocationContext invocationContext) throws Exception {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager;
        try {
            this.init(beanManager);
            this.doLifecycleInterception(invocationContext, InterceptionType.POST_CONSTRUCT);
        }
        finally {
            invocationContext.proceed();
        }
    }

    private void init(BeanManagerImpl beanManager) {
        this.ejbName = this.getEjbName();
        EjbDescriptor descriptor = beanManager.getEjbDescriptor(this.ejbName);
        SessionBean bean = beanManager.getBean(descriptor);
        this.creationalContext = beanManager.createCreationalContext((Contextual)bean);
        InterceptorBindings interceptorBindings = this.getInterceptorBindings(this.ejbName);
        if (interceptorBindings != null) {
            for (Interceptor interceptor : interceptorBindings.getAllInterceptors()) {
                this.addInterceptorInstance((Interceptor<Object>)interceptor, beanManager);
            }
        }
    }

    private InterceptorBindings getInterceptorBindings(String ejbName) {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager;
        EjbServices ejbServices = (EjbServices)beanManager.getServices().get(EjbServices.class);
        if (ejbServices instanceof ForwardingEjbServices) {
            ejbServices = ((ForwardingEjbServices)ejbServices).delegate();
        }
        InterceptorBindings interceptorBindings = null;
        if (ejbServices instanceof WeldEjbServices) {
            interceptorBindings = ((WeldEjbServices)ejbServices).getBindings(ejbName);
        }
        return interceptorBindings;
    }

    private void addInterceptorInstance(Interceptor<Object> interceptor, BeanManagerImpl beanManager) {
        Object instance = beanManager.getContext(interceptor.getScope()).get(interceptor, this.creationalContext);
        SerializableContextualInstance serializableContextualInstance = ((ContextualStore)beanManager.getServices().get(ContextualStore.class)).getSerializableContextualInstance(interceptor, instance, this.creationalContext);
        this.interceptorInstances.put(interceptor.getBeanClass().getName(), (SerializableContextualInstance<Interceptor<Object>, Object>)serializableContextualInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void doPreDestroy(InvocationContext invocationContext) throws Exception {
        try {
            this.doLifecycleInterception(invocationContext, InterceptionType.PRE_DESTROY);
            if (this.creationalContext != null) {
                this.creationalContext.release();
            }
        }
        finally {
            invocationContext.proceed();
        }
    }

    @AroundInvoke
    public Object doAroundInvoke(InvocationContext invocationContext) throws Exception {
        return this.doMethodInterception(invocationContext, InterceptionType.AROUND_INVOKE);
    }

    private void doLifecycleInterception(InvocationContext invocationContext, InterceptionType interceptionType) throws Exception {
        InterceptorBindings interceptorBindings = this.getInterceptorBindings(this.ejbName);
        if (interceptorBindings != null) {
            List currentInterceptors = interceptorBindings.getLifecycleInterceptors(interceptionType);
            this.delegateInterception(invocationContext, interceptionType, currentInterceptors);
        }
    }

    private Object doMethodInterception(InvocationContext invocationContext, InterceptionType interceptionType) throws Exception {
        InterceptorBindings interceptorBindings = this.getInterceptorBindings(this.ejbName);
        if (interceptorBindings != null) {
            List currentInterceptors = interceptorBindings.getMethodInterceptors(interceptionType, invocationContext.getMethod());
            return this.delegateInterception(invocationContext, interceptionType, currentInterceptors);
        }
        return invocationContext.proceed();
    }

    private Object delegateInterception(InvocationContext invocationContext, InterceptionType interceptionType, List<Interceptor<?>> currentInterceptors) throws Exception {
        ArrayList<Object> currentInterceptorInstances = new ArrayList<Object>();
        for (Interceptor<?> interceptor : currentInterceptors) {
            currentInterceptorInstances.add(this.interceptorInstances.get(interceptor.getBeanClass().getName()).getInstance());
        }
        if (currentInterceptorInstances.size() > 0) {
            return new DelegatingInterceptorInvocationContext(invocationContext, currentInterceptors, currentInterceptorInstances, interceptionType).proceed();
        }
        return invocationContext.proceed();
    }

    private EJBContext getEjbContext() {
        return CurrentInvocationContext.get().getEJBContext();
    }

    private String getEjbName() {
        EJBContext ejbContext = this.getEjbContext();
        if (ejbContext instanceof BaseSessionContext) {
            return ((EJBComponent)((BaseSessionContext)ejbContext).getComponent()).getComponentName();
        }
        throw new IllegalStateException("Unable to extract ejb name from EJBContext " + ejbContext);
    }
}

