/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.protocol.mgmt.ManagementChannel;

public class ManagementChannelPinger
extends Thread {
    private static final long PING_FREQUENCY = 2000L;
    private static final long PING_TIMEOUT = 10000L;
    private static volatile ManagementChannelPinger INSTANCE;
    private Set<ManagementChannel> channels = Collections.synchronizedSet(new HashSet());

    private ManagementChannelPinger() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ManagementChannelPinger.this.interrupt();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ManagementChannelPinger getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ManagementChannelPinger> clazz = ManagementChannelPinger.class;
        synchronized (ManagementChannelPinger.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ManagementChannelPinger();
            INSTANCE.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!ManagementChannelPinger.interrupted()) {
            HashSet<ManagementChannel> channels;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                break;
            }
            Set<ManagementChannel> set = this.channels;
            synchronized (set) {
                channels = new HashSet<ManagementChannel>(this.channels);
            }
            for (ManagementChannel channel : channels) {
                if (ManagementChannelPinger.interrupted()) {
                    this.interrupt();
                    break;
                }
                channel.ping(10000L);
            }
            if (!ManagementChannelPinger.interrupted()) continue;
            break;
        }
        this.interrupt();
    }

    void addChannel(ManagementChannel channel) {
        this.channels.add(channel);
    }

    void removeChannel(ManagementChannel channel) {
        this.channels.remove(channel);
    }
}

