/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.protocol.ProtocolChannel;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;

public abstract class ManagementRequest<T> {
    private final Logger log = Logger.getLogger((String)"org.jboss.as.protocol");
    private static final AtomicInteger requestId = new AtomicInteger();
    private final int currentRequestId = requestId.incrementAndGet();
    private final ManagementFuture<T> future = new ManagementFuture();
    private final int batchId;

    protected ManagementRequest() {
        this(0);
    }

    protected ManagementRequest(int batchId) {
        this.batchId = batchId;
    }

    protected abstract byte getRequestCode();

    protected int getCurrentRequestId() {
        return this.currentRequestId;
    }

    protected int getBatchId() {
        return this.batchId;
    }

    public AsyncFuture<T> execute(ExecutorService executor, final ManagementClientChannelStrategy channelStrategy) {
        this.log.tracef("Scheduling request %s with future %s - %d (%d)", new Object[]{this, this.future, this.getBatchId(), this.getCurrentRequestId()});
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ManagementChannel channel = channelStrategy.getChannel();
                    ManagementRequest.this.log.tracef("Got channel %s from request %s for %d", (Object)channel, (Object)ManagementRequest.this, (Object)ManagementRequest.this.getCurrentRequestId());
                    channel.executeRequest(ManagementRequest.this, new DelegatingResponseHandler(channelStrategy));
                }
                catch (Exception e) {
                    ManagementRequest.this.log.tracef((Throwable)e, "Could not get channel for request %s, failing %s for %d", (Object)ManagementRequest.this, (Object)ManagementRequest.this.future, (Object)ManagementRequest.this.getCurrentRequestId());
                    ManagementRequest.this.future.failed(e);
                }
            }
        });
        return this.future;
    }

    void writeRequest(ProtocolChannel channel, FlushableDataOutput output) throws IOException {
        this.writeRequest(1, output);
        output.writeByte(21);
    }

    public T executeForResult(ExecutorService executor, ManagementClientChannelStrategy channelStrategy) throws Exception {
        return (T)this.execute(executor, channelStrategy).get();
    }

    protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
    }

    protected CloseHandler<Channel> getRequestCloseHandler() {
        return null;
    }

    protected void setError(Exception e) {
        this.future.failed(e);
    }

    protected abstract ManagementResponseHandler<T> getResponseHandler();

    static class ManagementFuture<T>
    extends AsyncFutureTask<T> {
        protected ManagementFuture() {
            super(null);
        }

        void done(T result) {
            super.setResult(result);
        }

        void failed(Exception ex) {
            super.setFailed((Throwable)ex);
        }
    }

    private final class DelegatingResponseHandler
    extends ManagementResponseHandler<T> {
        private final ManagementClientChannelStrategy clientChannelStrategy;

        public DelegatingResponseHandler(ManagementClientChannelStrategy clientChannelStrategy) {
            this.clientChannelStrategy = clientChannelStrategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected T readResponse(DataInput input) {
            String error = this.getResponseHeader().getError();
            if (error != null) {
                ManagementRequest.this.future.failed(new IOException("A problem happened executing on the server: " + error));
                return null;
            }
            Object result = null;
            try {
                ManagementResponseHandler responseHandler = ManagementRequest.this.getResponseHandler();
                responseHandler.setContextInfo(this);
                result = responseHandler.readResponse(input);
                ManagementRequest.this.future.done(result);
                Object t = result;
                return t;
            }
            catch (Exception e) {
                ManagementRequest.this.setError(e);
            }
            finally {
                this.clientChannelStrategy.requestDone();
            }
            return result;
        }
    }
}

