/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.ejb.MessageDriven;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class MessageDrivenAnnotationProcessor
implements DeploymentUnitProcessor {
    static final DotName MESSAGE_DRIVEN_ANNOTATION_NAME = DotName.createSimple((String)MessageDriven.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        List instances = compositeIndex.getAnnotations(MESSAGE_DRIVEN_ANNOTATION_NAME);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        EjbDeploymentMarker.mark(deploymentUnit);
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        if (ejbJarDescription == null) {
            ejbJarDescription = new EjbJarDescription(moduleDescription, deploymentUnit.getName().endsWith(".war"));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbJarDescription);
        }
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) {
                throw new DeploymentUnitProcessingException("The @MessageDriven annotation is only allowed at the class level: " + target);
            }
            ClassInfo beanClassInfo = (ClassInfo)target;
            String beanClassName = beanClassInfo.name().toString();
            String ejbName = beanClassInfo.name().local();
            AnnotationValue nameValue = instance.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : nameValue.asString();
            String messageListenerInterfaceName = instance.value("messageListenerInterface").asClass().name().toString();
            MessageDrivenComponentDescription messageDrivenComponentDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
            messageDrivenComponentDescription.setMessageListenerInterfaceName(messageListenerInterfaceName);
            if (moduleDescription.getComponentByName(messageDrivenComponentDescription.getComponentName()) != null) continue;
            moduleDescription.addComponent((ComponentDescription)messageDrivenComponentDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

