/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.spec;

import java.util.HashMap;
import java.util.Map;

public enum Version {
    UNKNOWN(null, null),
    APP_1_3("http://java.sun.com/dtd/application_1_3.dtd", "1.3"),
    APP_1_4("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "1.4"),
    APP_5_0("http://java.sun.com/xml/ns/javaee/application_5.xsd", "5.0"),
    APP_6_0("http://java.sun.com/xml/ns/javaee/application_6.xsd", "6.0");

    private static final Map<String, Version> bindings;
    private final String location;
    private final String version;

    private Version(String location, String version) {
        this.location = location;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public static Version forLocation(String location) {
        Version version = bindings.get(location);
        return version != null ? version : UNKNOWN;
    }

    static {
        bindings = new HashMap<String, Version>();
        for (Version version : Version.values()) {
            bindings.put(version.location, version);
        }
    }
}

