/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.List;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

public class PersistenceUnitSearch {
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");
    private static final boolean traceEnabled = log.isTraceEnabled();

    public static PersistenceUnitMetadata resolvePersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        int i;
        if (traceEnabled) {
            log.tracef("pu search for name '%s' inside of %s", (Object)persistenceUnitName, (Object)deploymentUnit.getName());
        }
        int n = i = persistenceUnitName == null ? -1 : persistenceUnitName.indexOf(35);
        if (i != -1) {
            String path = persistenceUnitName.substring(0, i);
            String name = persistenceUnitName.substring(i + 1);
            PersistenceUnitMetadata pu = PersistenceUnitSearch.getPersistenceUnit(deploymentUnit, path, name);
            if (traceEnabled) {
                log.trace((Object)("pu search found " + pu.getScopedPersistenceUnitName()));
            }
            return pu;
        }
        PersistenceUnitMetadata name = PersistenceUnitSearch.findPersistenceUnitSupplier(deploymentUnit, persistenceUnitName);
        if (traceEnabled && name != null) {
            log.trace((Object)("pu search found " + name));
        }
        return name;
    }

    private static PersistenceUnitMetadata findPersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        PersistenceUnitMetadata name = PersistenceUnitSearch.findWithinDeployment(deploymentUnit, persistenceUnitName);
        if (name == null) {
            name = PersistenceUnitSearch.findWithinApplication(PersistenceUnitSearch.getTopLevel(deploymentUnit), persistenceUnitName);
        }
        return name;
    }

    private static PersistenceUnitMetadata findWithinApplication(DeploymentUnit unit, String persistenceUnitName) {
        PersistenceUnitMetadata name = PersistenceUnitSearch.findWithinDeployment(unit, persistenceUnitName);
        if (name != null) {
            return name;
        }
        List resourceRoots = unit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot) || (name = PersistenceUnitSearch.findWithinLibraryJar(resourceRoot, persistenceUnitName)) == null) continue;
            return name;
        }
        return null;
    }

    private static PersistenceUnitMetadata findWithinLibraryJar(ResourceRoot moduleResourceRoot, String persistenceUnitName) {
        ResourceRoot deploymentRoot = moduleResourceRoot;
        PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
        if (holder == null || holder.getPersistenceUnits() == null) {
            return null;
        }
        for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
            if (traceEnabled) {
                log.tracef("findWithinLibraryJar check '%s' against pu '%s'", (Object)persistenceUnitName, (Object)persistenceUnit.getPersistenceUnitName());
            }
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            if (traceEnabled) {
                log.tracef("findWithinLibraryJar matched '%s' against pu '%s'", (Object)persistenceUnitName, (Object)persistenceUnit.getPersistenceUnitName());
            }
            return persistenceUnit;
        }
        return null;
    }

    private static PersistenceUnitMetadata findWithinDeployment(DeploymentUnit unit, String persistenceUnitName) {
        ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
        if (holder == null || holder.getPersistenceUnits() == null) {
            return null;
        }
        for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
            if (traceEnabled) {
                log.tracef("findWithinDeployment check '%s' against pu '%s'", (Object)persistenceUnitName, (Object)persistenceUnit.getPersistenceUnitName());
            }
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            if (traceEnabled) {
                log.tracef("findWithinDeployment matched '%s' against pu '%s'", (Object)persistenceUnitName, (Object)persistenceUnit.getPersistenceUnitName());
            }
            return persistenceUnit;
        }
        return null;
    }

    private static DeploymentUnit getTopLevel(DeploymentUnit du) {
        return du.getParent() == null ? du : du.getParent();
    }

    private static PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit current, String absolutePath, String puName) {
        String path = absolutePath.startsWith("../") ? absolutePath.substring(3) : absolutePath;
        VirtualFile parent = ((ResourceRoot)current.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getParent();
        VirtualFile resolvedPath = parent.getChild(path);
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)PersistenceUnitSearch.getTopLevel(current));
        for (ResourceRoot resourceRoot : resourceRoots) {
            PersistenceUnitMetadataHolder holder;
            if (!resourceRoot.getRoot().equals(resolvedPath) || (holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) == null) continue;
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                if (traceEnabled) {
                    log.tracef("getPersistenceUnit check '%s' against pu '%s'", (Object)puName, (Object)pu.getPersistenceUnitName());
                }
                if (!pu.getPersistenceUnitName().equals(puName)) continue;
                if (traceEnabled) {
                    log.tracef("getPersistenceUnit matched '%s' against pu '%s'", (Object)puName, (Object)pu.getPersistenceUnitName());
                }
                return pu;
            }
        }
        throw new IllegalArgumentException("Can't find a deployment unit named " + absolutePath + "#" + puName + " at " + current);
    }
}

