/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.StandaloneXml;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.as.server.BootstrapImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.AsyncFuture;

public interface Bootstrap {
    public AsyncFuture<ServiceContainer> bootstrap(Configuration var1, List<ServiceActivator> var2);

    public AsyncFuture<ServiceContainer> startup(Configuration var1, List<ServiceActivator> var2);

    public static final class Factory {
        private Factory() {
        }

        public static Bootstrap newInstance() {
            return new BootstrapImpl();
        }
    }

    public static final class Configuration {
        private ServerEnvironment serverEnvironment;
        private ModuleLoader moduleLoader = Module.getBootModuleLoader();
        private ExtensibleConfigurationPersister configurationPersister;
        private long startTime = Module.getStartTime();

        public void setPortOffset(int portOffset) {
            if (portOffset < 0) {
                throw new IllegalArgumentException("portOffset may not be less than 0");
            }
        }

        public ServerEnvironment getServerEnvironment() {
            return this.serverEnvironment;
        }

        public synchronized void setServerEnvironment(ServerEnvironment serverEnvironment) {
            this.serverEnvironment = serverEnvironment;
        }

        public ModuleLoader getModuleLoader() {
            return this.moduleLoader;
        }

        public void setModuleLoader(ModuleLoader moduleLoader) {
            this.moduleLoader = moduleLoader;
        }

        public synchronized ExtensibleConfigurationPersister getConfigurationPersister() {
            if (this.configurationPersister == null) {
                if (this.serverEnvironment == null) {
                    this.configurationPersister = new NullConfigurationPersister((XMLElementWriter)new StandaloneXml(this.moduleLoader));
                } else {
                    QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                    StandaloneXml parser = new StandaloneXml(Module.getBootModuleLoader());
                    this.configurationPersister = new BackupXmlConfigurationPersister(this.serverEnvironment.getServerConfigurationFile(), rootElement, (XMLElementReader)parser, (XMLElementWriter)parser);
                }
            }
            return this.configurationPersister;
        }

        public synchronized void setConfigurationPersister(ExtensibleConfigurationPersister configurationPersister) {
            this.configurationPersister = configurationPersister;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }
    }
}

