/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.ModuleIdentifier;

public final class AdditionalModuleProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        AttachmentList<ResourceRoot> resourceRoots = deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
        if (resourceRoots != null) {
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (ModuleRootMarker.isModuleRoot(resourceRoot) || SubDeploymentMarker.isSubDeployment(resourceRoot)) continue;
                String pathName = resourceRoot.getRoot().getPathNameRelativeTo(deploymentRoot.getRoot());
                ModuleIdentifier identifier = ModuleIdentifier.create((String)("deployment." + deploymentUnit.getName() + "." + pathName));
                AdditionalModuleSpecification module = new AdditionalModuleSpecification(identifier, resourceRoot);
                deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_MODULES, module);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

