/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.cache.spi.access.AccessType;

public enum CacheConcurrencyStrategy {
    NONE(null),
    READ_ONLY(AccessType.READ_ONLY),
    NONSTRICT_READ_WRITE(AccessType.NONSTRICT_READ_WRITE),
    READ_WRITE(AccessType.READ_WRITE),
    TRANSACTIONAL(AccessType.TRANSACTIONAL);

    private final AccessType accessType;

    private CacheConcurrencyStrategy(AccessType accessType) {
        this.accessType = accessType;
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                return READ_ONLY;
            }
            case READ_WRITE: {
                return READ_WRITE;
            }
            case NONSTRICT_READ_WRITE: {
                return NONSTRICT_READ_WRITE;
            }
            case TRANSACTIONAL: {
                return TRANSACTIONAL;
            }
        }
        return NONE;
    }

    public static CacheConcurrencyStrategy parse(String name) {
        if (CacheConcurrencyStrategy.READ_ONLY.accessType.getExternalName().equalsIgnoreCase(name)) {
            return READ_ONLY;
        }
        if (CacheConcurrencyStrategy.READ_WRITE.accessType.getExternalName().equalsIgnoreCase(name)) {
            return READ_WRITE;
        }
        if (CacheConcurrencyStrategy.NONSTRICT_READ_WRITE.accessType.getExternalName().equalsIgnoreCase(name)) {
            return NONSTRICT_READ_WRITE;
        }
        if (CacheConcurrencyStrategy.TRANSACTIONAL.accessType.getExternalName().equalsIgnoreCase(name)) {
            return TRANSACTIONAL;
        }
        if ("none".equalsIgnoreCase(name)) {
            return NONE;
        }
        return null;
    }

    public AccessType toAccessType() {
        return this.accessType;
    }
}

