/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.integrator.internal;

import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.cfg.search.HibernateSearchIntegrator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class IntegratorServiceImpl
implements IntegratorService {
    private final ServiceRegistryImplementor serviceRegistry;
    private LinkedHashSet<Integrator> integrators = new LinkedHashSet();

    public IntegratorServiceImpl(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.integrators.add(new BeanValidationIntegrator());
        this.integrators.add(new HibernateSearchIntegrator());
    }

    @Override
    public void addIntegrator(Integrator integrator) {
        this.integrators.add(integrator);
    }

    @Override
    public Iterable<Integrator> getIntegrators() {
        LinkedHashSet<Integrator> integrators = new LinkedHashSet<Integrator>();
        integrators.addAll(this.integrators);
        for (Integrator integrator : ServiceLoader.load(Integrator.class)) {
            integrators.add(integrator);
        }
        return integrators;
    }
}

