/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityMappings;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClassHierarchy;
import org.hibernate.metamodel.source.annotations.entity.EntityBinder;
import org.hibernate.metamodel.source.annotations.global.FetchProfileBinder;
import org.hibernate.metamodel.source.annotations.global.FilterDefBinder;
import org.hibernate.metamodel.source.annotations.global.IdGeneratorBinder;
import org.hibernate.metamodel.source.annotations.global.QueryBinder;
import org.hibernate.metamodel.source.annotations.global.TableBinder;
import org.hibernate.metamodel.source.annotations.global.TypeDefBinder;
import org.hibernate.metamodel.source.annotations.util.ConfiguredClassHierarchyBuilder;
import org.hibernate.metamodel.source.annotations.xml.OrmXmlParser;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.hibernate.metamodel.source.spi.Binder;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class AnnotationBinder
implements Binder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AnnotationBinder.class.getName());
    private final MetadataImplementor metadata;
    private Index index;
    private ClassLoaderService classLoaderService;

    public AnnotationBinder(MetadataImpl metadata) {
        this.metadata = metadata;
    }

    @Override
    public void prepare(MetadataSources sources) {
        Indexer indexer = new Indexer();
        for (Class<?> clazz : sources.getAnnotatedClasses()) {
            this.indexClass(indexer, clazz.getName().replace('.', '/') + ".class");
        }
        for (String packageName : sources.getAnnotatedPackages()) {
            this.indexClass(indexer, packageName.replace('.', '/') + "/package-info.class");
        }
        this.index = indexer.complete();
        ArrayList<JaxbRoot<XMLEntityMappings>> mappings = new ArrayList<JaxbRoot<XMLEntityMappings>>();
        for (JaxbRoot root : sources.getJaxbRootList()) {
            if (!(root.getRoot() instanceof XMLEntityMappings)) continue;
            mappings.add(root);
        }
        if (!mappings.isEmpty()) {
            OrmXmlParser ormParser = new OrmXmlParser(this.metadata);
            this.index = ormParser.parseAndUpdateIndex(mappings, this.index);
        }
    }

    private void indexClass(Indexer indexer, String className) {
        InputStream stream = this.classLoaderService().locateResourceStream(className);
        try {
            indexer.index(stream);
        }
        catch (IOException e) {
            throw new HibernateException("Unable to open input stream for class " + className, e);
        }
    }

    private ClassLoaderService classLoaderService() {
        if (this.classLoaderService == null) {
            this.classLoaderService = this.metadata.getServiceRegistry().getService(ClassLoaderService.class);
        }
        return this.classLoaderService;
    }

    @Override
    public void bindIndependentMetadata(MetadataSources sources) {
        TypeDefBinder.bind(this.metadata, this.index);
    }

    @Override
    public void bindTypeDependentMetadata(MetadataSources sources) {
        IdGeneratorBinder.bind(this.metadata, this.index);
    }

    @Override
    public void bindMappingMetadata(MetadataSources sources, List<String> processedEntityNames) {
        Set<ConfiguredClassHierarchy> hierarchies = ConfiguredClassHierarchyBuilder.createEntityHierarchies(this.index, this.metadata.getServiceRegistry());
        for (ConfiguredClassHierarchy hierarchy : hierarchies) {
            for (ConfiguredClass configuredClass : hierarchy) {
                LOG.bindingEntityFromAnnotatedClass(configuredClass.getName());
                EntityBinder entityBinder = new EntityBinder(this.metadata, configuredClass);
                entityBinder.bind();
            }
        }
    }

    @Override
    public void bindMappingDependentMetadata(MetadataSources sources) {
        TableBinder.bind(this.metadata, this.index);
        FetchProfileBinder.bind(this.metadata, this.index);
        QueryBinder.bind(this.metadata, this.index);
        FilterDefBinder.bind(this.metadata, this.index);
    }
}

