/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.List;
import java.util.Map;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.ColumnValues;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class DiscriminatorColumnValues
extends ColumnValues {
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "DTYPE";
    private static final int DEFAULT_DISCRIMINATOR_LENGTH = 31;
    private boolean isForced = true;
    private boolean isIncludedInSql = true;
    private String discriminatorValue = null;

    public DiscriminatorColumnValues(Map<DotName, List<AnnotationInstance>> annotations) {
        AnnotationInstance discriminatorOptionsAnnotation = JandexHelper.getSingleAnnotation(annotations, JPADotNames.DISCRIMINATOR_COLUMN);
        if (discriminatorOptionsAnnotation != null) {
            this.setName(discriminatorOptionsAnnotation.value("name").asString());
            this.setLength(discriminatorOptionsAnnotation.value("length").asInt());
            if (discriminatorOptionsAnnotation.value("columnDefinition") != null) {
                this.setColumnDefinition(discriminatorOptionsAnnotation.value("columnDefinition").asString());
            }
        } else {
            this.setName(DEFAULT_DISCRIMINATOR_COLUMN_NAME);
            this.setLength(31);
        }
        this.setNullable(false);
        this.setDiscriminatorValue(annotations);
        this.setDiscriminatorOptions(annotations);
        this.setDiscriminatorFormula(annotations);
    }

    private void setDiscriminatorValue(Map<DotName, List<AnnotationInstance>> annotations) {
        AnnotationInstance discriminatorValueAnnotation = JandexHelper.getSingleAnnotation(annotations, JPADotNames.DISCRIMINATOR_VALUE);
        if (discriminatorValueAnnotation != null) {
            this.discriminatorValue = discriminatorValueAnnotation.value().asString();
        }
    }

    private void setDiscriminatorFormula(Map<DotName, List<AnnotationInstance>> annotations) {
        AnnotationInstance discriminatorFormulaAnnotation = JandexHelper.getSingleAnnotation(annotations, HibernateDotNames.DISCRIMINATOR_FORMULA);
        if (discriminatorFormulaAnnotation != null) {
            // empty if block
        }
    }

    public boolean isForced() {
        return this.isForced;
    }

    public boolean isIncludedInSql() {
        return this.isIncludedInSql;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    private void setDiscriminatorOptions(Map<DotName, List<AnnotationInstance>> annotations) {
        AnnotationInstance discriminatorOptionsAnnotation = JandexHelper.getSingleAnnotation(annotations, HibernateDotNames.DISCRIMINATOR_OPTIONS);
        if (discriminatorOptionsAnnotation != null) {
            this.isForced = discriminatorOptionsAnnotation.value("force").asBoolean();
            this.isIncludedInSql = discriminatorOptionsAnnotation.value("insert").asBoolean();
        }
    }
}

