/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GenerationType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.entity.DiscriminatorColumnValues;
import org.hibernate.metamodel.source.annotations.entity.MappedAttribute;
import org.hibernate.metamodel.source.annotations.entity.SimpleAttribute;
import org.hibernate.metamodel.source.annotations.entity.state.binding.AttributeBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.binding.DiscriminatorBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.binding.ManyToOneBindingStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.relational.ColumnRelationalStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.relational.ManyToOneRelationalStateImpl;
import org.hibernate.metamodel.source.annotations.entity.state.relational.TupleRelationalStateImpl;
import org.hibernate.metamodel.source.annotations.global.IdGeneratorBinder;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class EntityBinder {
    private final ConfiguredClass configuredClass;
    private final MetadataImplementor meta;
    private Schema.Name schemaName;

    public EntityBinder(MetadataImplementor metadata, ConfiguredClass configuredClass) {
        this.configuredClass = configuredClass;
        this.meta = metadata;
    }

    public void bind() {
        EntityBinding entityBinding = new EntityBinding();
        this.bindJpaEntityAnnotation(entityBinding);
        this.bindHibernateEntityAnnotation(entityBinding);
        this.schemaName = this.createSchemaName();
        this.bindTable(entityBinding);
        this.bindInheritance(entityBinding);
        this.bindWhereFilter(entityBinding);
        this.bindJpaCaching(entityBinding);
        this.bindHibernateCaching(entityBinding);
        this.bindProxy(entityBinding);
        if (this.configuredClass.isRoot()) {
            this.bindId(entityBinding);
        }
        this.bindAttributes(entityBinding);
        this.meta.addEntity(entityBinding);
    }

    private void bindInheritance(EntityBinding entityBinding) {
        entityBinding.setInheritanceType(this.configuredClass.getInheritanceType());
        switch (this.configuredClass.getInheritanceType()) {
            case SINGLE_TABLE: {
                this.bindDiscriminatorColumn(entityBinding);
                break;
            }
            case JOINED: {
                break;
            }
            case TABLE_PER_CLASS: {
                break;
            }
        }
    }

    private void bindDiscriminatorColumn(EntityBinding entityBinding) {
        Map<DotName, List<AnnotationInstance>> typeAnnotations = JandexHelper.getTypeAnnotations(this.configuredClass.getClassInfo());
        SimpleAttribute discriminatorAttribute = SimpleAttribute.createDiscriminatorAttribute(typeAnnotations);
        this.bindSingleMappedAttribute(entityBinding, discriminatorAttribute);
        if (!(discriminatorAttribute.getColumnValues() instanceof DiscriminatorColumnValues)) {
            throw new AssertionFailure("Expected discriminator column values");
        }
    }

    private void bindWhereFilter(EntityBinding entityBinding) {
        AnnotationInstance whereAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.WHERE);
        if (whereAnnotation != null) {
            String clause = whereAnnotation.value("clause").asString();
            entityBinding.setWhereFilter(clause);
        }
    }

    private void bindHibernateCaching(EntityBinding entityBinding) {
        AnnotationInstance cacheAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.CACHE);
        if (cacheAnnotation == null) {
            return;
        }
        String region = cacheAnnotation.value("region") != null ? cacheAnnotation.value("region").asString() : entityBinding.getEntity().getName();
        boolean cacheLazyProperties = true;
        if (cacheAnnotation.value("include") != null) {
            String tmp = cacheAnnotation.value("include").asString();
            if ("all".equalsIgnoreCase(tmp)) {
                cacheLazyProperties = true;
            } else if ("non-lazy".equalsIgnoreCase(tmp)) {
                cacheLazyProperties = false;
            } else {
                throw new AnnotationException("Unknown lazy property annotations: " + tmp);
            }
        }
        CacheConcurrencyStrategy strategy = CacheConcurrencyStrategy.valueOf(cacheAnnotation.value("usage").asEnum());
        Caching caching = new Caching(region, strategy.toAccessType(), cacheLazyProperties);
        entityBinding.setCaching(caching);
    }

    private void bindJpaCaching(EntityBinding entityBinding) {
        AnnotationInstance cacheAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.CACHEABLE);
        boolean cacheable = true;
        if (cacheAnnotation != null && cacheAnnotation.value() != null) {
            cacheable = cacheAnnotation.value().asBoolean();
        }
        Caching caching = null;
        switch (this.meta.getOptions().getSharedCacheMode()) {
            case ALL: {
                caching = this.createCachingForCacheableAnnotation(entityBinding);
                break;
            }
            case ENABLE_SELECTIVE: {
                if (!cacheable) break;
                caching = this.createCachingForCacheableAnnotation(entityBinding);
                break;
            }
            case DISABLE_SELECTIVE: {
                if (cacheAnnotation != null && !cacheable) break;
                caching = this.createCachingForCacheableAnnotation(entityBinding);
                break;
            }
        }
        if (caching != null) {
            entityBinding.setCaching(caching);
        }
    }

    private void bindProxy(EntityBinding entityBinding) {
        AnnotationInstance proxyAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.PROXY);
        boolean lazy = true;
        String proxyInterfaceClass = null;
        if (proxyAnnotation != null) {
            AnnotationValue proxyClassValue;
            AnnotationValue lazyValue = proxyAnnotation.value("lazy");
            if (lazyValue != null) {
                lazy = lazyValue.asBoolean();
            }
            if ((proxyClassValue = proxyAnnotation.value("proxyClass")) != null) {
                proxyInterfaceClass = proxyClassValue.asString();
            }
        }
        entityBinding.setLazy(lazy);
        entityBinding.setProxyInterfaceName(proxyInterfaceClass);
    }

    private Caching createCachingForCacheableAnnotation(EntityBinding entityBinding) {
        String region = entityBinding.getEntity().getName();
        RegionFactory regionFactory = this.meta.getServiceRegistry().getService(RegionFactory.class);
        AccessType defaultAccessType = regionFactory.getDefaultAccessType();
        return new Caching(region, defaultAccessType, true);
    }

    private Schema.Name createSchemaName() {
        String schema = null;
        String catalog = null;
        AnnotationInstance tableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.TABLE);
        if (tableAnnotation != null) {
            AnnotationValue schemaValue = tableAnnotation.value("schema");
            AnnotationValue catalogValue = tableAnnotation.value("catalog");
            schema = schemaValue != null ? schemaValue.asString() : null;
            catalog = catalogValue != null ? catalogValue.asString() : null;
        }
        return new Schema.Name(schema, catalog);
    }

    private void bindTable(EntityBinding entityBinding) {
        Identifier tableName;
        Schema schema = this.meta.getDatabase().getSchema(this.schemaName);
        Table table = schema.getTable(tableName = Identifier.toIdentifier(this.configuredClass.getPrimaryTableName()));
        if (table == null) {
            table = schema.createTable(tableName);
        }
        entityBinding.setBaseTable(table);
        AnnotationInstance checkAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.CHECK);
        if (checkAnnotation != null) {
            table.addCheckConstraint(checkAnnotation.value("constraints").asString());
        }
    }

    private void bindId(EntityBinding entityBinding) {
        entityBinding.setRoot(true);
        switch (this.configuredClass.getIdType()) {
            case SIMPLE: {
                this.bindSingleIdAnnotation(entityBinding);
                break;
            }
            case COMPOSED: {
                break;
            }
            case EMBEDDED: {
                break;
            }
        }
    }

    private void bindJpaEntityAnnotation(EntityBinding entityBinding) {
        AnnotationInstance jpaEntityAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.ENTITY);
        String name = jpaEntityAnnotation.value("name") == null ? this.configuredClass.getName() : jpaEntityAnnotation.value("name").asString();
        entityBinding.setEntity(new Entity(name, this.getSuperType()));
    }

    private void bindSingleIdAnnotation(EntityBinding entityBinding) {
        AnnotationInstance idAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.ID);
        String idName = JandexHelper.getPropertyName(idAnnotation.target());
        MappedAttribute idAttribute = this.configuredClass.getMappedProperty(idName);
        if (!(idAttribute instanceof SimpleAttribute)) {
            throw new AssertionFailure("Unexpected attribute type for id attribute");
        }
        entityBinding.getEntity().getOrCreateSingularAttribute(idName);
        SimpleAttributeBinding attributeBinding = entityBinding.makeSimpleIdAttributeBinding(idName);
        attributeBinding.initialize(new AttributeBindingStateImpl((SimpleAttribute)idAttribute));
        attributeBinding.initialize(new ColumnRelationalStateImpl((SimpleAttribute)idAttribute, this.meta));
        this.bindSingleIdGeneratedValue(entityBinding, idName);
    }

    private void bindSingleIdGeneratedValue(EntityBinding entityBinding, String idPropertyName) {
        AnnotationInstance generatedValueAnn = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.GENERATED_VALUE);
        if (generatedValueAnn == null) {
            return;
        }
        String idName = JandexHelper.getPropertyName(generatedValueAnn.target());
        if (!idPropertyName.equals(idName)) {
            throw new AssertionFailure(String.format("Attribute[%s.%s] with @GeneratedValue doesn't have a @Id.", this.configuredClass.getName(), idPropertyName));
        }
        String generator = JandexHelper.getValueAsString(generatedValueAnn, "generator");
        IdGenerator idGenerator = null;
        if (StringHelper.isNotEmpty(generator)) {
            idGenerator = this.meta.getIdGenerator(generator);
            if (idGenerator == null) {
                throw new MappingException(String.format("@GeneratedValue on %s.%s refering an undefined generator [%s]", this.configuredClass.getName(), idName, generator));
            }
            entityBinding.getEntityIdentifier().setIdGenerator(idGenerator);
        }
        GenerationType generationType = JandexHelper.getValueAsEnum(generatedValueAnn, "strategy", GenerationType.class);
        String strategy = IdGeneratorBinder.generatorType(generationType, this.meta.getOptions().useNewIdentifierGenerators());
        if (idGenerator != null && !strategy.equals(idGenerator.getStrategy())) {
            throw new MappingException(String.format("Inconsistent Id Generation strategy of @GeneratedValue on %s.%s", this.configuredClass.getName(), idName));
        }
        idGenerator = new IdGenerator("NAME", strategy, new HashMap<String, String>());
        entityBinding.getEntityIdentifier().setIdGenerator(idGenerator);
    }

    private void bindAttributes(EntityBinding entityBinding) {
        for (MappedAttribute mappedAttribute : this.configuredClass.getMappedAttributes()) {
            if (mappedAttribute instanceof AssociationAttribute) {
                this.bindAssociationAttribute(entityBinding, (AssociationAttribute)mappedAttribute);
                continue;
            }
            this.bindSingleMappedAttribute(entityBinding, (SimpleAttribute)mappedAttribute);
        }
    }

    private void bindAssociationAttribute(EntityBinding entityBinding, AssociationAttribute associationAttribute) {
        switch (associationAttribute.getAssociationType()) {
            case MANY_TO_ONE: {
                entityBinding.getEntity().getOrCreateSingularAttribute(associationAttribute.getName());
                ManyToOneAttributeBinding manyToOneAttributeBinding = entityBinding.makeManyToOneAttributeBinding(associationAttribute.getName());
                ManyToOneBindingStateImpl bindingState = new ManyToOneBindingStateImpl(associationAttribute);
                manyToOneAttributeBinding.initialize(bindingState);
                ManyToOneRelationalStateImpl relationalState = new ManyToOneRelationalStateImpl();
                if (this.configuredClass.hasOwnTable()) {
                    ColumnRelationalStateImpl columnRelationsState = new ColumnRelationalStateImpl(associationAttribute, this.meta);
                    relationalState.addValueState(columnRelationsState);
                }
                manyToOneAttributeBinding.initialize(relationalState);
                break;
            }
        }
    }

    private void bindSingleMappedAttribute(EntityBinding entityBinding, SimpleAttribute simpleAttribute) {
        AttributeBindingStateImpl bindingState;
        SimpleAttributeBinding attributeBinding;
        if (simpleAttribute.isId()) {
            return;
        }
        String attributeName = simpleAttribute.getName();
        entityBinding.getEntity().getOrCreateSingularAttribute(attributeName);
        if (simpleAttribute.isDiscriminator()) {
            EntityDiscriminator entityDiscriminator = entityBinding.makeEntityDiscriminator(attributeName);
            DiscriminatorBindingStateImpl bindingState2 = new DiscriminatorBindingStateImpl(simpleAttribute);
            entityDiscriminator.initialize(bindingState2);
            attributeBinding = entityDiscriminator.getValueBinding();
        } else if (simpleAttribute.isVersioned()) {
            attributeBinding = entityBinding.makeVersionBinding(attributeName);
            bindingState = new AttributeBindingStateImpl(simpleAttribute);
            attributeBinding.initialize(bindingState);
        } else {
            attributeBinding = entityBinding.makeSimpleAttributeBinding(attributeName);
            bindingState = new AttributeBindingStateImpl(simpleAttribute);
            attributeBinding.initialize(bindingState);
        }
        if (this.configuredClass.hasOwnTable()) {
            ColumnRelationalStateImpl columnRelationsState = new ColumnRelationalStateImpl(simpleAttribute, this.meta);
            TupleRelationalStateImpl relationalState = new TupleRelationalStateImpl();
            relationalState.addValueState(columnRelationsState);
            attributeBinding.initialize(relationalState);
        }
    }

    private void bindHibernateEntityAnnotation(EntityBinding entityBinding) {
        AnnotationInstance immutableAnnotation;
        boolean mutable = true;
        boolean dynamicInsert = false;
        boolean dynamicUpdate = false;
        boolean selectBeforeUpdate = false;
        PolymorphismType polymorphism = PolymorphismType.IMPLICIT;
        OptimisticLockType optimisticLock = OptimisticLockType.VERSION;
        AnnotationInstance hibernateEntityAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.ENTITY);
        if (hibernateEntityAnnotation != null) {
            if (hibernateEntityAnnotation.value("mutable") != null) {
                mutable = hibernateEntityAnnotation.value("mutable").asBoolean();
            }
            if (hibernateEntityAnnotation.value("dynamicInsert") != null) {
                dynamicInsert = hibernateEntityAnnotation.value("dynamicInsert").asBoolean();
            }
            if (hibernateEntityAnnotation.value("dynamicUpdate") != null) {
                dynamicUpdate = hibernateEntityAnnotation.value("dynamicUpdate").asBoolean();
            }
            if (hibernateEntityAnnotation.value("selectBeforeUpdate") != null) {
                selectBeforeUpdate = hibernateEntityAnnotation.value("selectBeforeUpdate").asBoolean();
            }
            if (hibernateEntityAnnotation.value("polymorphism") != null) {
                polymorphism = PolymorphismType.valueOf(hibernateEntityAnnotation.value("polymorphism").asEnum());
            }
            if (hibernateEntityAnnotation.value("optimisticLock") != null) {
                optimisticLock = OptimisticLockType.valueOf(hibernateEntityAnnotation.value("optimisticLock").asEnum());
            }
            if (hibernateEntityAnnotation.value("persister") != null) {
                String persister = hibernateEntityAnnotation.value("persister").toString();
                ClassLoaderService classLoaderService = this.meta.getServiceRegistry().getService(ClassLoaderService.class);
                Class persisterClass = classLoaderService.classForName(persister);
                entityBinding.setEntityPersisterClass(persisterClass);
            }
        }
        if ((immutableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.IMMUTABLE)) != null) {
            mutable = false;
        }
        entityBinding.setMutable(mutable);
        entityBinding.setDynamicInsert(dynamicInsert);
        entityBinding.setDynamicUpdate(dynamicUpdate);
        entityBinding.setSelectBeforeUpdate(selectBeforeUpdate);
        entityBinding.setExplicitPolymorphism(PolymorphismType.EXPLICIT.equals((Object)polymorphism));
        entityBinding.setOptimisticLockMode(optimisticLock.ordinal());
    }

    private Hierarchical getSuperType() {
        ConfiguredClass parent = this.configuredClass.getParent();
        if (parent == null) {
            return null;
        }
        EntityBinding parentBinding = this.meta.getEntityBinding(parent.getName());
        if (parentBinding == null) {
            throw new AssertionFailure("Parent entity " + parent.getName() + " of entity " + this.configuredClass.getName() + " not yet created!");
        }
        return parentBinding.getEntity();
    }
}

