/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.type.Type;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

public class FilterDefBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)FilterDefBinder.class.getName());

    public static void bind(MetadataImplementor metadata, Index jandex) {
        for (AnnotationInstance filterDef : jandex.getAnnotations(HibernateDotNames.FILTER_DEF)) {
            FilterDefBinder.bind(metadata, filterDef);
        }
        for (AnnotationInstance filterDefs : jandex.getAnnotations(HibernateDotNames.FILTER_DEFS)) {
            for (AnnotationInstance filterDef : JandexHelper.getValueAsArray(filterDefs, "value")) {
                FilterDefBinder.bind(metadata, filterDef);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance filterDef) {
        String name = JandexHelper.getValueAsString(filterDef, "name");
        HashMap<String, Type> prms = new HashMap<String, Type>();
        for (AnnotationInstance prm : JandexHelper.getValueAsArray(filterDef, "parameters")) {
            prms.put(JandexHelper.getValueAsString(prm, "name"), metadata.getTypeResolver().heuristicType(JandexHelper.getValueAsString(prm, "type")));
        }
        metadata.addFilterDefinition(new FilterDefinition(name, JandexHelper.getValueAsString(filterDef, "defaultCondition"), prms));
        LOG.debugf("Binding filter definition: %s", name);
    }

    private FilterDefBinder() {
    }
}

