/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.binding;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.metamodel.binding.CascadeType;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.state.PluralAttributeBindingState;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.state.binding.AbstractHbmAttributeBindingState;
import org.hibernate.metamodel.source.hbm.util.MappingHelper;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLBagElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlDeleteAllElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlDeleteElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlInsertElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlUpdateElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSynchronizeElement;
import org.hibernate.metamodel.source.spi.BindingContext;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;

public class HbmPluralAttributeBindingState
extends AbstractHbmAttributeBindingState
implements PluralAttributeBindingState {
    private final XMLBagElement collection;
    private final Class collectionPersisterClass;
    private final String typeName;
    private final Set<CascadeType> cascadeTypes;

    public HbmPluralAttributeBindingState(String ownerClassName, BindingContext bindingContext, MetaAttributeContext parentMetaAttributeContext, XMLBagElement collection) {
        super(ownerClassName, collection.getName(), bindingContext, collection.getNode(), HbmHelper.extractMetaAttributeContext(collection.getMeta(), parentMetaAttributeContext), HbmHelper.getPropertyAccessorName(collection.getAccess(), collection.isEmbedXml(), bindingContext.getMappingDefaults().getPropertyAccessorName()), collection.isOptimisticLock());
        this.collection = collection;
        this.collectionPersisterClass = MappingHelper.classForName(collection.getPersister(), this.getBindingContext().getServiceRegistry());
        this.cascadeTypes = this.determineCascadeTypes(collection.getCascade());
        this.typeName = collection.getCollectionType();
    }

    @Override
    public FetchMode getFetchMode() {
        FetchMode fetchMode;
        if (this.collection.getFetch() != null) {
            fetchMode = "join".equals(this.collection.getFetch().value()) ? FetchMode.JOIN : FetchMode.SELECT;
        } else {
            String jfNodeValue;
            String string = jfNodeValue = this.collection.getOuterJoin().value() == null ? "auto" : this.collection.getOuterJoin().value();
            fetchMode = "auto".equals(jfNodeValue) ? FetchMode.DEFAULT : ("true".equals(jfNodeValue) ? FetchMode.JOIN : FetchMode.SELECT);
        }
        return fetchMode;
    }

    @Override
    public boolean isLazy() {
        return this.isExtraLazy() || MappingHelper.getBooleanValue(this.collection.getLazy().value(), this.getBindingContext().getMappingDefaults().areAssociationsLazy());
    }

    @Override
    public boolean isExtraLazy() {
        return "extra".equals(this.collection.getLazy().value());
    }

    @Override
    public String getElementTypeName() {
        return this.collection.getElement().getTypeAttribute();
    }

    @Override
    public String getElementNodeName() {
        return this.collection.getElement().getNode();
    }

    @Override
    public boolean isInverse() {
        return this.collection.isInverse();
    }

    @Override
    public boolean isMutable() {
        return this.collection.isMutable();
    }

    @Override
    public boolean isSubselectLoadable() {
        return "subselect".equals(this.collection.getFetch().value());
    }

    @Override
    public String getCacheConcurrencyStrategy() {
        return this.collection.getCache() == null ? null : this.collection.getCache().getUsage();
    }

    @Override
    public String getCacheRegionName() {
        return this.collection.getCache() == null ? null : this.collection.getCache().getRegion();
    }

    @Override
    public String getOrderBy() {
        return this.collection.getOrderBy();
    }

    @Override
    public String getWhere() {
        return this.collection.getWhere();
    }

    @Override
    public String getReferencedPropertyName() {
        return this.collection.getKey().getPropertyRef();
    }

    @Override
    public boolean isSorted() {
        return !"unsorted".equals(this.getSortString());
    }

    @Override
    public Comparator getComparator() {
        return null;
    }

    @Override
    public String getComparatorClassName() {
        String sortString = this.getSortString();
        return this.isSorted() && !"natural".equals(sortString) ? sortString : null;
    }

    private String getSortString() {
        return "unsorted";
    }

    @Override
    public boolean isOrphanDelete() {
        return true;
    }

    @Override
    public int getBatchSize() {
        return MappingHelper.getIntValue(this.collection.getBatchSize(), 0);
    }

    @Override
    public boolean isEmbedded() {
        return this.collection.isEmbedXml();
    }

    @Override
    public boolean isOptimisticLocked() {
        return this.collection.isOptimisticLock();
    }

    @Override
    public Class getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    @Override
    public Map getFilters() {
        return new HashMap();
    }

    @Override
    public Set getSynchronizedTables() {
        HashSet<String> synchronizedTables = new HashSet<String>();
        for (XMLSynchronizeElement sync : this.collection.getSynchronize()) {
            synchronizedTables.add(sync.getTable());
        }
        return synchronizedTables;
    }

    @Override
    public CustomSQL getCustomSQLInsert() {
        XMLSqlInsertElement sqlInsert = this.collection.getSqlInsert();
        return sqlInsert == null ? null : HbmHelper.getCustomSql(this.collection.getSqlInsert().getValue(), this.collection.getSqlInsert().isCallable(), this.collection.getSqlInsert().getCheck().value());
    }

    @Override
    public CustomSQL getCustomSQLUpdate() {
        XMLSqlUpdateElement sqlUpdate = this.collection.getSqlUpdate();
        return sqlUpdate == null ? null : HbmHelper.getCustomSql(this.collection.getSqlUpdate().getValue(), this.collection.getSqlUpdate().isCallable(), this.collection.getSqlUpdate().getCheck().value());
    }

    @Override
    public CustomSQL getCustomSQLDelete() {
        XMLSqlDeleteElement sqlDelete = this.collection.getSqlDelete();
        return sqlDelete == null ? null : HbmHelper.getCustomSql(this.collection.getSqlDelete().getValue(), this.collection.getSqlDelete().isCallable(), this.collection.getSqlDelete().getCheck().value());
    }

    @Override
    public CustomSQL getCustomSQLDeleteAll() {
        XMLSqlDeleteAllElement sqlDeleteAll = this.collection.getSqlDeleteAll();
        return sqlDeleteAll == null ? null : HbmHelper.getCustomSql(this.collection.getSqlDeleteAll().getValue(), this.collection.getSqlDeleteAll().isCallable(), this.collection.getSqlDeleteAll().getCheck().value());
    }

    @Override
    public String getLoaderName() {
        return this.collection.getLoader() == null ? null : this.collection.getLoader().getQueryRef();
    }

    @Override
    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    @Override
    public boolean isKeyCascadeDeleteEnabled() {
        return false;
    }

    @Override
    public String getUnsavedValue() {
        return null;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }
}

