/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.security.AccessController;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ManagementOperationHandlerFactory;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.remoting.ChannelOpenListenerService;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.InjectedNetworkBindingStreamServerService;
import org.jboss.as.remoting.NetworkBindingStreamServerService;
import org.jboss.as.remoting.RealmAuthenticationProvider;
import org.jboss.as.remoting.RealmAuthenticationProviderService;
import org.jboss.as.remoting.RealmOptionMapService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.threads.QueueExecutor;
import org.xnio.OptionMap;

public final class RemotingServices {
    public static final ServiceName REMOTING = ServiceName.JBOSS.append(new String[]{"remoting"});
    public static final ServiceName AUTHENTICATION_PROVIDER = REMOTING.append(new String[]{"authentication_provider"});
    public static final ServiceName OPTION_MAP = AUTHENTICATION_PROVIDER.append(new String[]{"option_map"});
    public static final ServiceName ENDPOINT = REMOTING.append(new String[]{"endpoint"});
    public static final ServiceName CONNECTOR = REMOTING.append(new String[]{"connector"});
    public static final ServiceName SERVER = REMOTING.append(new String[]{"server"});
    public static final ServiceName CHANNEL = REMOTING.append(new String[]{"channel"});
    public static final String MANAGEMENT_CHANNEL = "management";
    public static final String DOMAIN_CHANNEL = "domain";
    public static final String SERVER_CHANNEL = "server";
    private static final long EXECUTOR_KEEP_ALIVE_TIME = 60000L;
    private static final int EXECUTOR_MAX_THREADS = 20;

    private RemotingServices() {
    }

    public static ExecutorService createExecutor() {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("Remoting"), Boolean.FALSE, null, "Remoting %f thread %t", null, null, AccessController.getContext());
        QueueExecutor executor = new QueueExecutor(6, 20, 60000L, TimeUnit.MILLISECONDS, 500, (ThreadFactory)threadFactory, true, null);
        return JBossExecutors.protectedExecutorService((Executor)executor);
    }

    public static ServiceName connectorServiceName(String connectorName) {
        return CONNECTOR.append(new String[]{connectorName});
    }

    public static ServiceName serverServiceName(String address, int port) {
        return SERVER.append(new String[]{address}).append(new String[]{String.valueOf(port)});
    }

    public static ServiceName channelServiceName(String channelName) {
        return CHANNEL.append(new String[]{channelName});
    }

    public static ServiceName operationHandlerName(ServiceName controllerName, String channelName) {
        return controllerName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    }

    public static void installRemotingEndpoint(ServiceTarget serviceTarget) {
        EndpointService endpointService = new EndpointService();
        endpointService.setOptionMap(OptionMap.EMPTY);
        Injector<Executor> executorInjector = endpointService.getExecutorInjector();
        executorInjector.inject((Object)Executors.newCachedThreadPool());
        serviceTarget.addService(ENDPOINT, (Service)endpointService).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public static void installDomainConnectorServices(ServiceTarget serviceTarget, NetworkInterfaceBinding networkInterfaceBinding, int port, ServiceName securityRealmName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName serverCallbackService = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory", "callback"});
        RemotingServices.installConnectorServices(serviceTarget, null, networkInterfaceBinding, port, securityRealmName, serverCallbackService, verificationHandler, newControllers);
    }

    public static void reinstallDomainConnectorServices(OperationContext operationContext, NetworkInterfaceBinding networkInterfaceBinding, int port, ServiceName securityRealmName) {
        RemotingServices.remoteConnectorServices(operationContext, port);
        RemotingServices.installDomainConnectorServices(operationContext.getServiceTarget(), networkInterfaceBinding, port, securityRealmName, null, null);
    }

    public static void installStandaloneConnectorServices(ServiceTarget serviceTarget, ServiceName networkInterfaceBindingName, int port, ServiceName securityRealmName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RemotingServices.installConnectorServices(serviceTarget, networkInterfaceBindingName, null, port, securityRealmName, null, verificationHandler, newControllers);
    }

    public static void installChannelOpenListenerService(ServiceTarget serviceTarget, String channelName, ServiceName operationHandlerName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ChannelOpenListenerService channelOpenListenerService = new ChannelOpenListenerService(channelName, OptionMap.EMPTY);
        ServiceBuilder builder = serviceTarget.addService(channelOpenListenerService.getServiceName(), (Service)channelOpenListenerService).addDependency(ENDPOINT, Endpoint.class, channelOpenListenerService.getEndpointInjector()).addDependency(operationHandlerName, ManagementOperationHandlerFactory.class, channelOpenListenerService.getOperationHandlerInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        RemotingServices.addController(newControllers, verificationHandler, builder);
    }

    public static void installChannelServices(ServiceTarget serviceTarget, AbstractModelControllerOperationHandlerFactoryService<?> operationHandlerService, ServiceName modelControllerName, String channelName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName operationHandlerName = RemotingServices.operationHandlerName(modelControllerName, channelName);
        ServiceBuilder builder = serviceTarget.addService(operationHandlerName, operationHandlerService).addDependency(modelControllerName, ModelController.class, (Injector)operationHandlerService.getModelControllerInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        RemotingServices.addController(newControllers, verificationHandler, builder);
        RemotingServices.installChannelOpenListenerService(serviceTarget, channelName, operationHandlerName, verificationHandler, newControllers);
    }

    private static void addController(List<ServiceController<?>> newControllers, ServiceVerificationHandler verificationHandler, ServiceBuilder<?> builder) {
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    private static void installConnectorServices(ServiceTarget serviceTarget, ServiceName networkInterfaceBindingName, NetworkInterfaceBinding networkInterfaceBinding, int port, ServiceName securityRealmName, ServiceName serverCallbackService, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RealmAuthenticationProviderService raps = new RealmAuthenticationProviderService();
        ServiceBuilder builder = serviceTarget.addService(AUTHENTICATION_PROVIDER, (Service)raps);
        if (securityRealmName != null) {
            builder.addDependency(securityRealmName, SecurityRealm.class, raps.getSecurityRealmInjectedValue());
        }
        if (serverCallbackService != null) {
            builder.addDependency(serverCallbackService, CallbackHandler.class, raps.getServerCallbackValue());
        }
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        RealmOptionMapService roms = new RealmOptionMapService();
        serviceTarget.addService(OPTION_MAP, (Service)roms).addDependency(AUTHENTICATION_PROVIDER, RealmAuthenticationProvider.class, roms.getRealmAuthenticationProviderInjectedValue()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (networkInterfaceBindingName != null) {
            InjectedNetworkBindingStreamServerService streamServerService = new InjectedNetworkBindingStreamServerService(port);
            builder = serviceTarget.addService(RemotingServices.serverServiceName(MANAGEMENT_CHANNEL, port), (Service)streamServerService).addDependency(AUTHENTICATION_PROVIDER, ServerAuthenticationProvider.class, streamServerService.getAuthenticationProviderInjector()).addDependency(OPTION_MAP, OptionMap.class, streamServerService.getOptionMapInjectedValue()).addDependency(ENDPOINT, Endpoint.class, streamServerService.getEndpointInjector()).addDependency(networkInterfaceBindingName, NetworkInterfaceBinding.class, streamServerService.getInterfaceBindingInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
            RemotingServices.addController(newControllers, verificationHandler, builder);
        } else {
            NetworkBindingStreamServerService streamServerService = new NetworkBindingStreamServerService(networkInterfaceBinding, port);
            builder = serviceTarget.addService(RemotingServices.serverServiceName(MANAGEMENT_CHANNEL, port), (Service)streamServerService).addDependency(AUTHENTICATION_PROVIDER, ServerAuthenticationProvider.class, streamServerService.getAuthenticationProviderInjector()).addDependency(OPTION_MAP, OptionMap.class, streamServerService.getOptionMapInjectedValue()).addDependency(ENDPOINT, Endpoint.class, streamServerService.getEndpointInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
            RemotingServices.addController(newControllers, verificationHandler, builder);
        }
    }

    private static void remoteConnectorServices(OperationContext context, int port) {
        context.removeService(RemotingServices.serverServiceName(MANAGEMENT_CHANNEL, port));
        context.removeService(OPTION_MAP);
        context.removeService(AUTHENTICATION_PROVIDER);
    }
}

