/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.vfs.VirtualFile;

public class EjbLookup {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.ejb");
    private final Map<String, EjbDescription> ejbs;
    private final Map<Class<?>, Set<EjbDescription>> ejbsByViewType;

    public EjbLookup(Map<String, EjbDescription> ejbs) {
        this.ejbs = ejbs;
        HashMap ejbsByViewType = new HashMap();
        for (EjbDescription ejb : ejbs.values()) {
            for (Class view : ejb.serviceNames.keySet()) {
                HashSet<EjbDescription> ejbList = (HashSet<EjbDescription>)ejbsByViewType.get(view);
                if (ejbList == null) {
                    ejbList = new HashSet<EjbDescription>();
                    ejbsByViewType.put(view, ejbList);
                }
                ejbList.add(ejb);
            }
        }
        this.ejbsByViewType = ejbsByViewType;
    }

    public ServiceName getViewService(String ejbName, Class<?> type) {
        EjbDescription description = this.ejbs.get(ejbName);
        if (description == null) {
            throw new RuntimeException("Could not find EJB with name " + ejbName);
        }
        if (type == null) {
            if (description.serviceNames.size() == 1) {
                return (ServiceName)description.serviceNames.values().iterator().next();
            }
            if (description.serviceNames.isEmpty()) {
                throw new RuntimeException("EJB " + ejbName + " does not have any views");
            }
            throw new RuntimeException("Could not determine view type to inject for ejb " + ejbName);
        }
        if (description.serviceNames.size() == 1) {
            return (ServiceName)description.serviceNames.values().iterator().next();
        }
        ServiceName serviceName = description.serviceName(type);
        if (serviceName == null) {
            throw new RuntimeException("Could not find a view of type " + type + " for EJB " + ejbName);
        }
        return serviceName;
    }

    public ServiceName getViewService(Class<?> type) {
        Set<EjbDescription> ejbs = this.ejbsByViewType.get(type);
        if (ejbs == null || ejbs.isEmpty()) {
            throw new RuntimeException("Could not resolve EJB with a view type of " + type);
        }
        if (ejbs.size() == 1) {
            return ejbs.iterator().next().serviceName(type);
        }
        EjbDescription localEjb = null;
        for (EjbDescription ejb : ejbs) {
            if (!ejb.deployedInCurrentModule) continue;
            if (localEjb != null) {
                throw new RuntimeException("More than one bean exists with a view of type " + type + " Beans: " + ejbs);
            }
            localEjb = ejb;
        }
        if (localEjb != null) {
            return localEjb.serviceName(type);
        }
        throw new RuntimeException("More than one bean exists with a view of type " + type + " Beans: " + ejbs);
    }

    public static Builder builder(DeploymentUnit deploymentUnit) {
        return new Builder(deploymentUnit);
    }

    public static class Builder {
        private final DeploymentUnit deploymentUnit;
        private final VirtualFile jarRoot;
        private final Map<String, EjbDescription> ejbs = new HashMap<String, EjbDescription>();

        public Builder(DeploymentUnit deploymentUnit) {
            this.deploymentUnit = deploymentUnit;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            this.jarRoot = deploymentRoot.getRoot().getParent();
        }

        public void addEjb(DeploymentUnit ejbDeploymentUnit, EJBComponentDescription componentDescription, ClassLoader classLoader) {
            ResourceRoot deploymentRoot;
            HashMap views = new HashMap();
            for (ViewDescription view : componentDescription.getViews()) {
                try {
                    Class<?> viewClass = classLoader.loadClass(view.getViewClassName());
                    views.put(viewClass, view.getServiceName());
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Could not load view class " + view.getViewClassName() + " for ejb " + componentDescription.getEJBClassName()));
                }
            }
            boolean deployedInCurrentModule = ejbDeploymentUnit.equals(this.deploymentUnit);
            EjbDescription description = new EjbDescription(views, deployedInCurrentModule, componentDescription.getEJBName());
            if (deployedInCurrentModule || !this.ejbs.containsKey(componentDescription.getEJBName())) {
                this.ejbs.put(componentDescription.getEJBName(), description);
            }
            if ((deploymentRoot = (ResourceRoot)ejbDeploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)) != null) {
                this.ejbs.put("../" + deploymentRoot.getRoot().getPathNameRelativeTo(this.jarRoot) + "#" + componentDescription.getEJBName(), description);
            }
        }

        public EjbLookup build() {
            return new EjbLookup(this.ejbs);
        }
    }

    private static final class EjbDescription {
        private final Map<Class<?>, ServiceName> serviceNames;
        private final boolean deployedInCurrentModule;
        private final String ejbName;

        public EjbDescription(Map<Class<?>, ServiceName> serviceNames, boolean deployedInCurrentModule, String ejbName) {
            this.serviceNames = serviceNames;
            this.deployedInCurrentModule = deployedInCurrentModule;
            this.ejbName = ejbName;
        }

        public ServiceName serviceName(Class<?> viewType) {
            return this.serviceNames.get(viewType);
        }

        public String toString() {
            return this.ejbName;
        }
    }
}

