/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;

public class SecurityIdentityDDProcessor
extends AbstractEjbXmlDescriptorProcessor<EnterpriseBeanMetaData> {
    @Override
    protected Class<EnterpriseBeanMetaData> getMetaDataType() {
        return EnterpriseBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(EnterpriseBeanMetaData beanMetaData, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        SecurityIdentityMetaData securityIdentity = beanMetaData.getSecurityIdentity();
        if (securityIdentity == null) {
            return;
        }
        RunAsMetaData runAs = securityIdentity.getRunAs();
        if (runAs == null) {
            return;
        }
        String runAsRole = runAs.getRoleName();
        if (runAsRole != null && !runAsRole.trim().isEmpty()) {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)moduleDescription.getComponentByName(beanMetaData.getEjbName());
            ejbComponentDescription.setRunAs(runAsRole);
        }
    }
}

