/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.pool.StatelessObjectFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPool<T>
implements Pool<T> {
    private static final Logger log = Logger.getLogger(AbstractPool.class);
    private final StatelessObjectFactory<T> factory;
    private AtomicInteger createCount = new AtomicInteger(0);
    private AtomicInteger removeCount = new AtomicInteger(0);

    protected AbstractPool(StatelessObjectFactory<T> factory) {
        assert (factory != null) : "factory is null";
        this.factory = factory;
    }

    @Override
    public int getCreateCount() {
        return this.createCount.get();
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount.get();
    }

    @Override
    public abstract void setMaxSize(int var1);

    protected T create() {
        T bean = this.factory.create();
        this.createCount.incrementAndGet();
        return bean;
    }

    @Deprecated
    protected void remove(T bean) {
        this.doRemove(bean);
    }

    protected void destroy(T bean) {
        this.doRemove(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(T bean) {
        try {
            this.factory.destroy(bean);
        }
        finally {
            this.removeCount.incrementAndGet();
        }
    }
}

