/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Level;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.FileHandlerService;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class FileHandlerAdd
extends AbstractAddStepHandler {
    static final FileHandlerAdd INSTANCE = new FileHandlerAdd();

    FileHandlerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("autoflush").set(operation.get("autoflush"));
        model.get("encoding").set(operation.get("encoding"));
        model.get("formatter").set(operation.get("formatter"));
        model.get("level").set(operation.get("level"));
        model.get("file").set(operation.get("file"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        try {
            FileHandlerService service = new FileHandlerService();
            ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
            if (operation.hasDefined("file")) {
                HandlerFileService fileService = new HandlerFileService(operation.get(new String[]{"file", "path"}).asString());
                ServiceBuilder fileBuilder = serviceTarget.addService(LogServices.handlerFileName(name), (Service)fileService);
                if (operation.get("file").hasDefined("relative-to")) {
                    fileBuilder.addDependency(AbstractPathService.pathNameOf((String)operation.get(new String[]{"file", "relative-to"}).asString()), String.class, fileService.getRelativeToInjector());
                }
                fileBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                serviceBuilder.addDependency(LogServices.handlerFileName(name), String.class, service.getFileNameInjector());
            }
            service.setLevel(Level.parse(operation.get("level").asString()));
            Boolean autoFlush = operation.get("autoflush").asBoolean();
            if (autoFlush != null) {
                service.setAutoflush(autoFlush);
            }
            if (operation.hasDefined("encoding")) {
                service.setEncoding(operation.get("encoding").asString());
            }
            if (operation.hasDefined("formatter")) {
                service.setFormatterSpec(FileHandlerAdd.createFormatterSpec(operation));
            }
            serviceBuilder.addListener((ServiceListener)verificationHandler);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            newControllers.add(serviceBuilder.install());
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }

    static AbstractFormatterSpec createFormatterSpec(ModelNode operation) {
        return new PatternFormatterSpec(operation.get("formatter").asString());
    }
}

