/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.file;

import java.beans.PropertyEditorSupport;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.file.FileCacheStore;

public class FileCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private static final long serialVersionUID = 1551092386868095926L;
    private String location = "Infinispan-FileCacheStore";
    private int streamBufferSize = 8192;
    private FsyncMode fsyncMode = FsyncMode.DEFAULT;
    private long fsyncInterval = 1000L;

    public FileCacheStoreConfig() {
        this.setCacheLoaderClassName(FileCacheStore.class.getName());
    }

    public String getLocation() {
        return this.location;
    }

    @Deprecated
    public void setLocation(String location) {
        this.testImmutability("location");
        this.location = location;
    }

    public FileCacheStoreConfig location(String location) {
        this.setLocation(location);
        return this;
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    @Deprecated
    public void setStreamBufferSize(int streamBufferSize) {
        this.testImmutability("steamBufferSize");
        this.streamBufferSize = streamBufferSize;
    }

    public FileCacheStoreConfig streamBufferSize(int streamBufferSize) {
        this.setStreamBufferSize(streamBufferSize);
        return this;
    }

    @Override
    public FileCacheStoreConfig purgeOnStartup(Boolean purgeOnStartup) {
        super.purgeOnStartup(purgeOnStartup);
        return this;
    }

    @Override
    public FileCacheStoreConfig purgeSynchronously(Boolean purgeSynchronously) {
        super.purgeSynchronously(purgeSynchronously);
        return this;
    }

    @Override
    public FileCacheStoreConfig fetchPersistentState(Boolean fetchPersistentState) {
        super.fetchPersistentState(fetchPersistentState);
        return this;
    }

    @Override
    public FileCacheStoreConfig ignoreModifications(Boolean ignoreModifications) {
        super.ignoreModifications(ignoreModifications);
        return this;
    }

    public long getFsyncInterval() {
        return this.fsyncInterval;
    }

    public void setFsyncInterval(long fsyncInterval) {
        this.fsyncInterval = fsyncInterval;
    }

    public FileCacheStoreConfig fsyncInterval(long fsyncInterval) {
        this.setFsyncInterval(fsyncInterval);
        return this;
    }

    public FsyncMode getFsyncMode() {
        return this.fsyncMode;
    }

    public void setFsyncMode(FsyncMode fsyncMode) {
        this.fsyncMode = fsyncMode;
    }

    public FileCacheStoreConfig fsyncMode(FsyncMode fsyncMode) {
        this.setFsyncMode(fsyncMode);
        return this;
    }

    public static class FsyncModeEditor
    extends PropertyEditorSupport {
        private FsyncMode mode;

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text.equals("default")) {
                this.mode = FsyncMode.DEFAULT;
            } else if (text.equals("perWrite")) {
                this.mode = FsyncMode.PER_WRITE;
            } else if (text.equals("periodic")) {
                this.mode = FsyncMode.PERIODIC;
            } else {
                throw new IllegalArgumentException("Unknown fsyncMode value: " + text);
            }
        }

        @Override
        public Object getValue() {
            return this.mode;
        }
    }

    public static enum FsyncMode {
        DEFAULT,
        PER_WRITE,
        PERIODIC;

    }
}

