/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.CollectionElement;
import org.hibernate.metamodel.binding.CollectionElementType;
import org.hibernate.metamodel.binding.CollectionKey;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.state.PluralAttributeBindingState;
import org.hibernate.metamodel.relational.Table;
import org.jboss.logging.Logger;

public abstract class PluralAttributeBinding
extends AbstractAttributeBinding {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PluralAttributeBinding.class.getName());
    private Table collectionTable;
    private CollectionKey collectionKey;
    private final CollectionElement collectionElement;
    private FetchMode fetchMode;
    private boolean extraLazy;
    private boolean inverse;
    private boolean mutable = true;
    private boolean subselectLoadable;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private String orderBy;
    private String where;
    private String referencedPropertyName;
    private boolean sorted;
    private Comparator comparator;
    private String comparatorClassName;
    private boolean orphanDelete;
    private int batchSize = -1;
    private boolean embedded = true;
    private boolean optimisticLocked = true;
    private Class collectionPersisterClass;
    private final Map filters = new HashMap();
    private final Set<String> synchronizedTables = new HashSet<String>();
    private CustomSQL customSQLInsert;
    private CustomSQL customSQLUpdate;
    private CustomSQL customSQLDelete;
    private CustomSQL customSQLDeleteAll;
    private String loaderName;

    protected PluralAttributeBinding(EntityBinding entityBinding, CollectionElementType collectionElementType) {
        super(entityBinding);
        this.collectionElement = collectionElementType.createCollectionElement(this);
    }

    protected void initializeBinding(PluralAttributeBindingState state) {
        super.initialize(state);
        this.fetchMode = state.getFetchMode();
        this.extraLazy = state.isExtraLazy();
        this.collectionElement.setNodeName(state.getElementNodeName());
        this.collectionElement.setTypeName(state.getElementTypeName());
        this.inverse = state.isInverse();
        this.mutable = state.isMutable();
        this.subselectLoadable = state.isSubselectLoadable();
        if (this.isSubselectLoadable()) {
            this.getEntityBinding().setSubselectLoadableCollections(true);
        }
        this.cacheConcurrencyStrategy = state.getCacheConcurrencyStrategy();
        this.cacheRegionName = state.getCacheRegionName();
        this.orderBy = state.getOrderBy();
        this.where = state.getWhere();
        this.referencedPropertyName = state.getReferencedPropertyName();
        this.sorted = state.isSorted();
        this.comparator = state.getComparator();
        this.comparatorClassName = state.getComparatorClassName();
        this.orphanDelete = state.isOrphanDelete();
        this.batchSize = state.getBatchSize();
        this.embedded = state.isEmbedded();
        this.optimisticLocked = state.isOptimisticLocked();
        this.collectionPersisterClass = state.getCollectionPersisterClass();
        this.filters.putAll(state.getFilters());
        this.synchronizedTables.addAll(state.getSynchronizedTables());
        this.customSQLInsert = state.getCustomSQLInsert();
        this.customSQLUpdate = state.getCustomSQLUpdate();
        this.customSQLDelete = state.getCustomSQLDelete();
        this.customSQLDeleteAll = state.getCustomSQLDeleteAll();
        this.loaderName = state.getLoaderName();
    }

    @Override
    public boolean isSimpleValue() {
        return false;
    }

    public Table getCollectionTable() {
        return this.collectionTable;
    }

    public void setCollectionTable(Table collectionTable) {
        this.collectionTable = collectionTable;
    }

    public CollectionKey getCollectionKey() {
        return this.collectionKey;
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        this.collectionKey = collectionKey;
    }

    public CollectionElement getCollectionElement() {
        return this.collectionElement;
    }

    public boolean isExtraLazy() {
        return this.extraLazy;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    public String getCacheConcurrencyStrategy() {
        return this.cacheConcurrencyStrategy;
    }

    public String getCacheRegionName() {
        return this.cacheRegionName;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getWhere() {
        return this.where;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public boolean isOrphanDelete() {
        return this.orphanDelete;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isOptimisticLocked() {
        return this.optimisticLocked;
    }

    public Class getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    public Map getFilterMap() {
        return this.filters;
    }

    public CustomSQL getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public CustomSQL getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public CustomSQL getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public CustomSQL getCustomSQLDeleteAll() {
        return this.customSQLDeleteAll;
    }

    public String getLoaderName() {
        return this.loaderName;
    }
}

