/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotation.xml.XMLAssociationOverride;
import org.hibernate.metamodel.source.annotation.xml.XMLAttributeOverride;
import org.hibernate.metamodel.source.annotation.xml.XMLCollectionTable;
import org.hibernate.metamodel.source.annotation.xml.XMLColumn;
import org.hibernate.metamodel.source.annotation.xml.XMLEnumType;
import org.hibernate.metamodel.source.annotation.xml.XMLJoinColumn;
import org.hibernate.metamodel.source.annotation.xml.XMLJoinTable;
import org.hibernate.metamodel.source.annotation.xml.XMLLob;
import org.hibernate.metamodel.source.annotation.xml.XMLOrderColumn;
import org.hibernate.metamodel.source.annotation.xml.XMLPrimaryKeyJoinColumn;
import org.hibernate.metamodel.source.annotation.xml.XMLTemporalType;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.DefaultConfigurationHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.SchemaAware;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

abstract class AnnotationMocker
extends AbstractMocker {
    private EntityMappingsMocker.Default defaults;

    AnnotationMocker(IndexBuilder indexBuilder, EntityMappingsMocker.Default defaults) {
        super(indexBuilder);
        this.defaults = defaults;
    }

    abstract void process();

    protected EntityMappingsMocker.Default getDefaults() {
        return this.defaults;
    }

    protected boolean isDefaultCascadePersist() {
        return this.defaults.isCascadePersist() != null && this.defaults.isCascadePersist() != false;
    }

    protected AnnotationInstance parserJoinTable(XMLJoinTable joinTable, AnnotationTarget target) {
        if (joinTable == null) {
            return null;
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(new SchemaAware.JoinTableSchemaAware(joinTable), this.getDefaults());
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", joinTable.getName(), annotationValueList);
        MockHelper.stringValue("catalog", joinTable.getCatalog(), annotationValueList);
        MockHelper.stringValue("schema", joinTable.getSchema(), annotationValueList);
        this.nestedJoinColumnList("joinColumns", joinTable.getJoinColumn(), annotationValueList);
        this.nestedJoinColumnList("inverseJoinColumns", joinTable.getInverseJoinColumn(), annotationValueList);
        this.nestedUniqueConstraintList("uniqueConstraints", joinTable.getUniqueConstraint(), annotationValueList);
        return this.create(JOIN_TABLE, target, annotationValueList);
    }

    private AnnotationInstance parserAssociationOverride(XMLAssociationOverride associationOverride, AnnotationTarget target) {
        if (associationOverride == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", associationOverride.getName(), annotationValueList);
        if (associationOverride instanceof XMLAssociationOverrideProxy) {
            XMLAssociationOverrideProxy proxy = (XMLAssociationOverrideProxy)associationOverride;
            MockHelper.addToCollectionIfNotNull(annotationValueList, proxy.getJoinColumnsAnnotationValue());
            MockHelper.addToCollectionIfNotNull(annotationValueList, proxy.getJoinTableAnnotationValue());
        } else {
            this.nestedJoinColumnList("joinColumns", associationOverride.getJoinColumn(), annotationValueList);
            MockHelper.nestedAnnotationValue("joinTable", this.parserJoinTable(associationOverride.getJoinTable(), null), annotationValueList);
        }
        return this.create(ASSOCIATION_OVERRIDE, target, annotationValueList);
    }

    private AnnotationValue[] nestedJoinColumnList(String name, List<XMLJoinColumn> columns, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(columns)) {
            AnnotationValue[] values = new AnnotationValue[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserJoinColumn(columns.get(i), null);
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
            return values;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }

    protected AnnotationInstance parserColumn(XMLColumn column, AnnotationTarget target) {
        if (column == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", column.getName(), annotationValueList);
        MockHelper.stringValue("columnDefinition", column.getColumnDefinition(), annotationValueList);
        MockHelper.stringValue("table", column.getTable(), annotationValueList);
        MockHelper.booleanValue("unique", column.isUnique(), annotationValueList);
        MockHelper.booleanValue("nullable", column.isNullable(), annotationValueList);
        MockHelper.booleanValue("insertable", column.isInsertable(), annotationValueList);
        MockHelper.booleanValue("updatable", column.isUpdatable(), annotationValueList);
        MockHelper.integerValue("length", column.getLength(), annotationValueList);
        MockHelper.integerValue("precision", column.getPrecision(), annotationValueList);
        MockHelper.integerValue("scale", column.getScale(), annotationValueList);
        return this.create(COLUMN, target, annotationValueList);
    }

    private AnnotationInstance parserAttributeOverride(XMLAttributeOverride attributeOverride, AnnotationTarget target) {
        if (attributeOverride == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", attributeOverride.getName(), annotationValueList);
        if (attributeOverride instanceof XMLAttributeOverrideProxy) {
            XMLAttributeOverrideProxy proxy = (XMLAttributeOverrideProxy)attributeOverride;
            MockHelper.addToCollectionIfNotNull(annotationValueList, proxy.getColumnAnnotationValue());
        } else {
            MockHelper.nestedAnnotationValue("column", this.parserColumn(attributeOverride.getColumn(), null), annotationValueList);
        }
        return this.create(ATTRIBUTE_OVERRIDE, target, annotationValueList);
    }

    protected AnnotationInstance parserOrderColumn(XMLOrderColumn orderColumn, AnnotationTarget target) {
        if (orderColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", orderColumn.getName(), annotationValueList);
        MockHelper.stringValue("columnDefinition", orderColumn.getColumnDefinition(), annotationValueList);
        MockHelper.booleanValue("nullable", orderColumn.isNullable(), annotationValueList);
        MockHelper.booleanValue("insertable", orderColumn.isInsertable(), annotationValueList);
        MockHelper.booleanValue("updatable", orderColumn.isUpdatable(), annotationValueList);
        return this.create(ORDER_COLUMN, target, annotationValueList);
    }

    protected AnnotationInstance parserJoinColumn(XMLJoinColumn column, AnnotationTarget target) {
        if (column == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", column.getName(), annotationValueList);
        MockHelper.stringValue("columnDefinition", column.getColumnDefinition(), annotationValueList);
        MockHelper.stringValue("table", column.getTable(), annotationValueList);
        MockHelper.stringValue("referencedColumnName", column.getReferencedColumnName(), annotationValueList);
        MockHelper.booleanValue("unique", column.isUnique(), annotationValueList);
        MockHelper.booleanValue("nullable", column.isNullable(), annotationValueList);
        MockHelper.booleanValue("insertable", column.isInsertable(), annotationValueList);
        MockHelper.booleanValue("updatable", column.isUpdatable(), annotationValueList);
        return this.create(JOIN_COLUMN, target, annotationValueList);
    }

    protected AnnotationInstance parserLob(XMLLob lob, AnnotationTarget target) {
        if (lob == null) {
            return null;
        }
        return this.create(LOB, target);
    }

    protected AnnotationInstance parserTemporalType(XMLTemporalType temporalType, AnnotationTarget target) {
        if (temporalType == null) {
            return null;
        }
        return this.create(TEMPORAL, target, MockHelper.enumValueArray("value", TEMPORAL_TYPE, temporalType));
    }

    protected AnnotationInstance parserEnumType(XMLEnumType enumerated, AnnotationTarget target) {
        if (enumerated == null) {
            return null;
        }
        return this.create(ENUMERATED, target, MockHelper.enumValueArray("value", ENUM_TYPE, enumerated));
    }

    protected AnnotationInstance parserPrimaryKeyJoinColumn(XMLPrimaryKeyJoinColumn primaryKeyJoinColumn, AnnotationTarget target) {
        if (primaryKeyJoinColumn == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", primaryKeyJoinColumn.getName(), annotationValueList);
        MockHelper.stringValue("referencedColumnName", primaryKeyJoinColumn.getReferencedColumnName(), annotationValueList);
        MockHelper.stringValue("columnDefinition", primaryKeyJoinColumn.getColumnDefinition(), annotationValueList);
        return this.create(PRIMARY_KEY_JOIN_COLUMN, target, annotationValueList);
    }

    protected AnnotationInstance parserPrimaryKeyJoinColumnList(List<XMLPrimaryKeyJoinColumn> primaryKeyJoinColumnList, AnnotationTarget target) {
        if (MockHelper.isNotEmpty(primaryKeyJoinColumnList)) {
            if (primaryKeyJoinColumnList.size() == 1) {
                return this.parserPrimaryKeyJoinColumn(primaryKeyJoinColumnList.get(0), target);
            }
            return this.create(PRIMARY_KEY_JOIN_COLUMNS, target, this.nestedPrimaryKeyJoinColumnList("value", primaryKeyJoinColumnList, null));
        }
        return null;
    }

    protected AnnotationValue[] nestedPrimaryKeyJoinColumnList(String name, List<XMLPrimaryKeyJoinColumn> constraints, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(constraints)) {
            AnnotationValue[] values = new AnnotationValue[constraints.size()];
            for (int i = 0; i < constraints.size(); ++i) {
                AnnotationInstance annotationInstance = this.parserPrimaryKeyJoinColumn(constraints.get(i), null);
                values[i] = MockHelper.nestedAnnotationValue("", annotationInstance);
            }
            MockHelper.addToCollectionIfNotNull(annotationValueList, AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values));
            return values;
        }
        return MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY;
    }

    protected void getAnnotationInstanceByTarget(DotName annName, AnnotationTarget target, Operation operation) {
        Map<DotName, List<AnnotationInstance>> annotatedMap = this.indexBuilder.getIndexedAnnotations(this.getTargetName());
        if (!annotatedMap.containsKey(annName)) {
            return;
        }
        List<AnnotationInstance> annotationInstanceList = annotatedMap.get(annName);
        if (MockHelper.isNotEmpty(annotationInstanceList)) {
            for (AnnotationInstance annotationInstance : annotationInstanceList) {
                AnnotationTarget annotationTarget = annotationInstance.target();
                if (!MockHelper.targetEquals(target, annotationTarget) || !operation.process(annotationInstance)) continue;
                return;
            }
        }
    }

    protected AnnotationInstance parserAttributeOverrides(List<XMLAttributeOverride> attributeOverrides, AnnotationTarget target) {
        if (target == null) {
            throw new AssertionFailure("target can not be null");
        }
        if (attributeOverrides == null || attributeOverrides.isEmpty()) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (XMLAttributeOverride attributeOverride : attributeOverrides) {
            names.add(attributeOverride.getName());
        }
        AttributeOverrideOperation operation = new AttributeOverrideOperation(names, attributeOverrides);
        this.getAnnotationInstanceByTarget(ATTRIBUTE_OVERRIDES, target, new ContainerOperation(operation));
        this.getAnnotationInstanceByTarget(ATTRIBUTE_OVERRIDE, target, operation);
        if (attributeOverrides.size() == 1) {
            return this.parserAttributeOverride(attributeOverrides.get(0), target);
        }
        AnnotationValue[] values = new AnnotationValue[attributeOverrides.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = MockHelper.nestedAnnotationValue("", this.parserAttributeOverride(attributeOverrides.get(i), null));
        }
        return this.create(ATTRIBUTE_OVERRIDES, target, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])values)});
    }

    protected AnnotationInstance parserAssociationOverrides(List<XMLAssociationOverride> associationOverrides, AnnotationTarget target) {
        if (target == null) {
            throw new AssertionFailure("target can not be null");
        }
        if (associationOverrides == null || associationOverrides.isEmpty()) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (XMLAssociationOverride associationOverride : associationOverrides) {
            names.add(associationOverride.getName());
        }
        AssociationOverrideOperation operation = new AssociationOverrideOperation(names, associationOverrides);
        this.getAnnotationInstanceByTarget(ASSOCIATION_OVERRIDES, target, new ContainerOperation(operation));
        this.getAnnotationInstanceByTarget(ASSOCIATION_OVERRIDE, target, operation);
        if (associationOverrides.size() == 1) {
            return this.parserAssociationOverride(associationOverrides.get(0), target);
        }
        AnnotationValue[] values = new AnnotationValue[associationOverrides.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = MockHelper.nestedAnnotationValue("", this.parserAssociationOverride(associationOverrides.get(i), null));
        }
        return this.create(ASSOCIATION_OVERRIDES, target, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])values)});
    }

    protected AnnotationInstance parserCollectionTable(XMLCollectionTable collectionTable, AnnotationTarget target) {
        if (collectionTable == null) {
            return null;
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(new SchemaAware.CollectionTableSchemaAware(collectionTable), this.getDefaults());
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("name", collectionTable.getName(), annotationValueList);
        MockHelper.stringValue("catalog", collectionTable.getCatalog(), annotationValueList);
        MockHelper.stringValue("schema", collectionTable.getSchema(), annotationValueList);
        this.nestedJoinColumnList("joinColumns", collectionTable.getJoinColumn(), annotationValueList);
        this.nestedUniqueConstraintList("uniqueConstraints", collectionTable.getUniqueConstraint(), annotationValueList);
        return this.create(COLLECTION_TABLE, target, annotationValueList);
    }

    protected AnnotationInstance parserJoinColumnList(List<XMLJoinColumn> joinColumnList, AnnotationTarget target) {
        if (MockHelper.isNotEmpty(joinColumnList)) {
            if (joinColumnList.size() == 1) {
                return this.parserJoinColumn(joinColumnList.get(0), target);
            }
            AnnotationValue[] values = this.nestedJoinColumnList("value", joinColumnList, null);
            return this.create(JOIN_COLUMNS, target, values);
        }
        return null;
    }

    protected AnnotationInstance create(DotName name) {
        return this.create(name, MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY);
    }

    protected AnnotationInstance create(DotName name, AnnotationValue[] annotationValues) {
        return this.create(name, this.getTarget(), annotationValues);
    }

    protected AnnotationInstance create(DotName name, List<AnnotationValue> annotationValueList) {
        return this.create(name, this.getTarget(), annotationValueList);
    }

    protected abstract DotName getTargetName();

    protected abstract AnnotationTarget getTarget();

    @Override
    protected AnnotationInstance push(AnnotationInstance annotationInstance) {
        if (annotationInstance != null && annotationInstance.target() != null) {
            this.indexBuilder.addAnnotationInstance(this.getTargetName(), annotationInstance);
        }
        return annotationInstance;
    }

    class XMLAttributeOverrideProxy
    extends XMLAttributeOverride {
        private AnnotationValue columnAnnotationValue;

        XMLAttributeOverrideProxy() {
        }

        AnnotationValue getColumnAnnotationValue() {
            return this.columnAnnotationValue;
        }

        void setColumnAnnotationValue(AnnotationValue columnAnnotationValue) {
            this.columnAnnotationValue = columnAnnotationValue;
        }
    }

    class XMLAssociationOverrideProxy
    extends XMLAssociationOverride {
        private AnnotationValue joinTableAnnotationValue;
        private AnnotationValue joinColumnsAnnotationValue;

        XMLAssociationOverrideProxy() {
        }

        AnnotationValue getJoinColumnsAnnotationValue() {
            return this.joinColumnsAnnotationValue;
        }

        void setJoinColumnsAnnotationValue(AnnotationValue joinColumnsAnnotationValue) {
            this.joinColumnsAnnotationValue = joinColumnsAnnotationValue;
        }

        AnnotationValue getJoinTableAnnotationValue() {
            return this.joinTableAnnotationValue;
        }

        void setJoinTableAnnotationValue(AnnotationValue joinTableAnnotationValue) {
            this.joinTableAnnotationValue = joinTableAnnotationValue;
        }
    }

    class AssociationOverrideOperation
    implements Operation {
        private Set<String> names;
        private List<XMLAssociationOverride> associationOverrides;

        AssociationOverrideOperation(Set<String> names, List<XMLAssociationOverride> associationOverrides) {
            this.names = names;
            this.associationOverrides = associationOverrides;
        }

        @Override
        public boolean process(AnnotationInstance annotationInstance) {
            String name = annotationInstance.value("name").asString();
            if (!this.names.contains(name)) {
                XMLAssociationOverrideProxy associationOverride = new XMLAssociationOverrideProxy();
                associationOverride.setName(name);
                associationOverride.setJoinColumnsAnnotationValue(annotationInstance.value("joinColumns"));
                associationOverride.setJoinTableAnnotationValue(annotationInstance.value("joinTable"));
                this.associationOverrides.add(associationOverride);
            }
            return false;
        }
    }

    class AttributeOverrideOperation
    implements Operation {
        private Set<String> names;
        private List<XMLAttributeOverride> attributeOverrides;

        AttributeOverrideOperation(Set<String> names, List<XMLAttributeOverride> attributeOverrides) {
            this.names = names;
            this.attributeOverrides = attributeOverrides;
        }

        @Override
        public boolean process(AnnotationInstance annotationInstance) {
            String name = annotationInstance.value("name").asString();
            if (!this.names.contains(name)) {
                XMLAttributeOverrideProxy attributeOverride = new XMLAttributeOverrideProxy();
                attributeOverride.setName(name);
                attributeOverride.setColumnAnnotationValue(annotationInstance.value("column"));
                this.attributeOverrides.add(attributeOverride);
            }
            return false;
        }
    }

    class ContainerOperation
    implements Operation {
        private Operation child;

        ContainerOperation(Operation child) {
            this.child = child;
        }

        @Override
        public boolean process(AnnotationInstance annotationInstance) {
            AnnotationInstance[] indexedAttributeOverridesValues;
            AnnotationValue value = annotationInstance.value();
            for (AnnotationInstance ai : indexedAttributeOverridesValues = value.asNestedArray()) {
                this.child.process(ai);
            }
            return true;
        }
    }

    protected static interface Operation {
        public boolean process(AnnotationInstance var1);
    }
}

