/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class MasterDomainControllerOperationHandlerImpl
extends AbstractModelControllerOperationHandler {
    private final ModelControllerClientOperationHandler clientHandler;
    private volatile ManagementOperationHandler proxyHandler;
    private final DomainController domainController;
    private final UnregisteredHostChannelRegistry registry;

    public MasterDomainControllerOperationHandlerImpl(ExecutorService executorService, ModelController controller, UnregisteredHostChannelRegistry registry, DomainController domainController) {
        super(executorService, controller);
        this.domainController = domainController;
        this.registry = registry;
        this.clientHandler = new ModelControllerClientOperationHandler(executorService, controller);
    }

    public ManagementRequestHandler getRequestHandler(byte id) {
        ManagementRequestHandler handler = this.clientHandler.getRequestHandler(id);
        if (handler != null) {
            return handler;
        }
        if (this.proxyHandler != null && (handler = this.proxyHandler.getRequestHandler(id)) != null) {
            return handler;
        }
        switch (id) {
            case 81: {
                return new RegisterOperation();
            }
            case 83: {
                return new UnregisterOperation();
            }
            case 85: {
                return new GetFileOperation();
            }
        }
        return null;
    }

    private class GetFileOperation
    extends RegistryOperation {
        private File localPath;
        private byte rootId;
        private String filePath;

        private GetFileOperation() {
        }

        @Override
        protected void readRequest(DataInput input) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)36);
            this.rootId = input.readByte();
            ProtocolUtils.expectHeader((DataInput)input, (int)37);
            this.filePath = input.readUTF();
        }

        protected void processRequest() throws RequestProcessingException {
            FileRepository localFileRepository = MasterDomainControllerOperationHandlerImpl.this.domainController.getFileRepository();
            switch (this.rootId) {
                case 38: {
                    this.localPath = localFileRepository.getFile(this.filePath);
                    break;
                }
                case 39: {
                    this.localPath = localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)this.filePath);
                    this.localPath = localFileRepository.getDeploymentRoot(hash);
                    break;
                }
                default: {
                    throw new RequestProcessingException(String.format("Invalid root id [%d]", this.rootId));
                }
            }
        }

        protected void writeResponse(FlushableDataOutput output) throws IOException {
            output.writeByte(41);
            if (this.localPath == null || !this.localPath.exists()) {
                output.writeInt(-1);
            } else if (this.localPath.isFile()) {
                output.writeInt(1);
                this.writeFile(this.localPath, output);
            } else {
                List<File> childFiles = this.getChildFiles(this.localPath);
                output.writeInt(childFiles.size());
                for (File child : childFiles) {
                    this.writeFile(child, output);
                }
            }
        }

        private List<File> getChildFiles(File base) {
            ArrayList<File> childFiles = new ArrayList<File>();
            this.getChildFiles(base, childFiles);
            return childFiles;
        }

        private void getChildFiles(File base, List<File> childFiles) {
            for (File child : base.listFiles()) {
                if (child.isFile()) {
                    childFiles.add(child);
                    continue;
                }
                this.getChildFiles(child, childFiles);
            }
        }

        private String getRelativePath(File parent, File child) {
            return child.getAbsolutePath().substring(parent.getAbsolutePath().length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, FlushableDataOutput output) throws IOException {
            output.writeByte(48);
            output.writeByte(37);
            output.writeUTF(this.getRelativePath(this.localPath, file));
            output.writeByte(49);
            output.writeLong(file.length());
            FileInputStream inputStream = null;
            try {
                int len;
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ignored) {}
                }
            }
            output.writeByte(50);
            output.flush();
        }
    }

    private class UnregisterOperation
    extends RegistryOperation {
        private UnregisterOperation() {
        }

        protected void processRequest() throws RequestProcessingException {
            MasterDomainControllerOperationHandlerImpl.this.domainController.unregisterRemoteHost(this.hostId);
        }
    }

    private class RegisterOperation
    extends RegistryOperation {
        String error;

        private RegisterOperation() {
        }

        @Override
        protected void readRequest(DataInput input) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            this.hostId = input.readUTF();
        }

        protected void processRequest() throws RequestProcessingException {
            try {
                MasterDomainControllerOperationHandlerImpl.this.registry.registerChannel(this.hostId, this.getChannel(), new UnregisteredHostChannelRegistry.ProxyCreatedCallback(){

                    public void proxyCreated(ManagementOperationHandler handler) {
                        MasterDomainControllerOperationHandlerImpl.this.proxyHandler = handler;
                    }
                });
                ModelNode op = new ModelNode();
                op.get("operation").set("read-master-domain-model");
                op.get("address").setEmptyList();
                op.get("host").set(this.hostId);
                ModelNode result = MasterDomainControllerOperationHandlerImpl.this.controller.execute(op, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, null);
                if (result.hasDefined("failure-description")) {
                    this.error = result.get("failure-description").asString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = e.getMessage();
            }
        }

        protected void writeResponse(FlushableDataOutput output) throws IOException {
            if (this.error != null) {
                output.write(34);
                output.writeUTF(this.error);
            } else {
                output.write(33);
            }
        }
    }

    private abstract class RegistryOperation
    extends ManagementRequestHandler {
        String hostId;

        RegistryOperation() {
        }

        protected void readRequest(DataInput input) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            this.hostId = input.readUTF();
        }
    }
}

