/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;

class DeploymentModelUtils {
    static final AttachmentKey<Resource> DEPLOYMENT_RESOURCE = AttachmentKey.create(Resource.class);
    static final AttachmentKey<ImmutableManagementResourceRegistration> REGISTRATION_ATTACHMENT = AttachmentKey.create(ImmutableManagementResourceRegistration.class);
    static final String SUBSYSTEM = "subsystem";
    static final String SUB_DEPLOYMENT = "subdeployment";

    DeploymentModelUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelNode createDeploymentSubModel(String subsystemName, PathElement address, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = unit.getAttachment(DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ImmutableManagementResourceRegistration registration = unit.getAttachment(REGISTRATION_ATTACHMENT);
            Resource subsystem = DeploymentModelUtils.getOrCreate(root, PathElement.pathElement((String)SUBSYSTEM, (String)subsystemName));
            ImmutableManagementResourceRegistration subModel = registration.getSubModel(DeploymentModelUtils.getExtensionAddress(subsystemName, address));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            return DeploymentModelUtils.getOrCreate(subsystem, address).getModel();
        }
    }

    static Resource createSubDeployment(String deploymentName, DeploymentUnit parent) {
        Resource root = parent.getAttachment(DEPLOYMENT_RESOURCE);
        return DeploymentModelUtils.getOrCreate(root, PathElement.pathElement((String)SUB_DEPLOYMENT, (String)deploymentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Resource getOrCreate(Resource parent, PathElement element) {
        Resource resource = parent;
        synchronized (resource) {
            if (parent.hasChild(element)) {
                return parent.requireChild(element);
            }
            Resource resource2 = Resource.Factory.create();
            parent.registerChild(element, resource2);
            return resource2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup(Resource resource) {
        Resource resource2 = resource;
        synchronized (resource2) {
            for (Resource.ResourceEntry entry : resource.getChildren(SUBSYSTEM)) {
                resource.removeChild(entry.getPathElement());
            }
            for (Resource.ResourceEntry entry : resource.getChildren(SUB_DEPLOYMENT)) {
                resource.removeChild(entry.getPathElement());
            }
        }
    }

    static PathAddress getExtensionAddress(String subsystemName, PathElement element) {
        return PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)SUBSYSTEM, (String)subsystemName), element});
    }
}

