/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.management;

import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.management.JndiViewExtension;
import org.jboss.as.naming.management.JndiViewExtensionContext;
import org.jboss.as.naming.management.JndiViewExtensionRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class JndiViewOperation
implements OperationStepHandler {
    public static final JndiViewOperation INSTANCE = new JndiViewOperation();
    public static final String OPERATION_NAME = "jndi-view";

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode resultNode = context.getResult();
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    ModelNode contextsNode = resultNode.get("java: contexts");
                    ServiceController jbossContextService = serviceRegistry.getService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME);
                    NamingStore jbossContextNamingStore = (NamingStore)NamingStore.class.cast(jbossContextService.getValue());
                    try {
                        JndiViewOperation.this.addEntries(contextsNode.get("java:jboss"), new NamingContext(jbossContextNamingStore, null));
                    }
                    catch (NamingException e) {
                        throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to read java:jboss context entries."));
                    }
                    ServiceController globalContextService = serviceRegistry.getService(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME);
                    NamingStore globalContextNamingStore = (NamingStore)NamingStore.class.cast(globalContextService.getValue());
                    try {
                        JndiViewOperation.this.addEntries(contextsNode.get("java:global"), new NamingContext(globalContextNamingStore, null));
                    }
                    catch (NamingException e) {
                        throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to read java:global context entries."));
                    }
                    ServiceController extensionRegistryController = serviceRegistry.getService(JndiViewExtensionRegistry.SERVICE_NAME);
                    if (extensionRegistryController != null) {
                        JndiViewExtensionRegistry extensionRegistry = (JndiViewExtensionRegistry)JndiViewExtensionRegistry.class.cast(extensionRegistryController.getValue());
                        for (JndiViewExtension extension : extensionRegistry.getExtensions()) {
                            extension.execute(new JndiViewExtensionContext(){

                                @Override
                                public OperationContext getOperationContext() {
                                    return context;
                                }

                                @Override
                                public ModelNode getResult() {
                                    return resultNode;
                                }

                                @Override
                                public void addEntries(ModelNode current, Context context2) throws NamingException {
                                    JndiViewOperation.this.addEntries(current, context2);
                                }
                            });
                        }
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            resultNode.set("Jndi view is only available in runtime mode.");
        }
        context.completeStep();
    }

    private void addEntries(ModelNode current, Context context) throws NamingException {
        NamingEnumeration<NameClassPair> entries = context.list("");
        while (entries.hasMore()) {
            NameClassPair pair = entries.next();
            ModelNode node = current.get(pair.getName());
            node.get("class-name").set(pair.getClassName());
            try {
                Object value = context.lookup(pair.getName());
                if (value instanceof Context) {
                    this.addEntries(node.get("children"), (Context)Context.class.cast(value));
                    continue;
                }
                if (value instanceof Reference) continue;
                node.get("value").set(value.toString());
            }
            catch (NamingException e) {}
        }
    }
}

