/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.operations;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.management.security.LdapConnectionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class ConnectionAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final ConnectionAddHandler INSTANCE = new ConnectionAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("type").set(operation.require("type").asString());
        model.get("url").set(operation.require("url").asString());
        model.get("search-dn").set(operation.require("search-dn").asString());
        model.get("search-credential").set(operation.require("search-credential").asString());
        if (operation.has("initial-context-factory")) {
            model.get("initial-context-factory").set(operation.require("initial-context-factory").asString());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String type = operation.get("type").asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        if ("ldap".equals(type)) {
            LdapConnectionManagerService connectionManagerService = new LdapConnectionManagerService(model);
            newControllers.add(serviceTarget.addService(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{name}), (Service)connectionManagerService).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

