/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.SSLIdentityService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SecurityRealmService
implements Service<SecurityRealmService>,
SecurityRealm {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "security_realm"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain-management");
    private final InjectedValue<DomainCallbackHandler> callbackHandler = new InjectedValue();
    private final InjectedValue<SSLIdentityService> sslIdentity = new InjectedValue();
    private final InjectedValue<CallbackHandlerFactory> secretCallbackFactory = new InjectedValue();
    private final String name;

    public SecurityRealmService(String name) {
        this.name = name;
    }

    public void start(StartContext context) throws StartException {
        log.infof("Starting '%s' Security Realm Service", (Object)this.name);
    }

    public void stop(StopContext context) {
        log.infof("Stopping '%s' Security Realm Service", (Object)this.name);
    }

    public SecurityRealmService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public InjectedValue<DomainCallbackHandler> getCallbackHandlerInjector() {
        return this.callbackHandler;
    }

    public InjectedValue<SSLIdentityService> getSSLIdentityInjector() {
        return this.sslIdentity;
    }

    public InjectedValue<CallbackHandlerFactory> getSecretCallbackFactory() {
        return this.secretCallbackFactory;
    }

    @Override
    public DomainCallbackHandler getCallbackHandler() {
        DomainCallbackHandler response = (DomainCallbackHandler)this.callbackHandler.getOptionalValue();
        if (response == null) {
            response = new DomainCallbackHandler(){

                @Override
                public Class[] getSupportedCallbacks() {
                    return new Class[0];
                }

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    throw new IllegalStateException("No authentication mechanism defined in security realm.");
                }
            };
        }
        return response;
    }

    @Override
    public SSLContext getSSLContext() {
        SSLIdentityService service = (SSLIdentityService)this.sslIdentity.getOptionalValue();
        if (this.sslIdentity != null) {
            return service.getSSLContext();
        }
        return null;
    }

    @Override
    public CallbackHandlerFactory getSecretCallbackHandlerFactory() {
        return (CallbackHandlerFactory)this.secretCallbackFactory.getValue();
    }
}

