/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.security.PermitAll;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class PermitAllProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final DotName PERMIT_ALL_DOT_NAME = DotName.createSimple((String)PermitAll.class.getName());

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo klass = beanClass;
        while (klass != null) {
            Map annotationsOnBean = klass.annotations();
            if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
                klass = this.getSuperClass(klass, index);
                continue;
            }
            List permitAllAnnotations = (List)annotationsOnBean.get(PERMIT_ALL_DOT_NAME);
            if (permitAllAnnotations == null || permitAllAnnotations.isEmpty()) {
                klass = this.getSuperClass(klass, index);
                continue;
            }
            for (AnnotationInstance permitAllAnnotation : permitAllAnnotations) {
                AnnotationTarget target = permitAllAnnotation.target();
                if (target instanceof ClassInfo) {
                    componentDescription.applyPermitAllOnAllViewsForClass(((ClassInfo)target).name().toString());
                    continue;
                }
                if (!(target instanceof MethodInfo)) continue;
                MethodInfo methodInfo = (MethodInfo)target;
                EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethodInfo(methodInfo);
                componentDescription.applyPermitAllOnAllViewsForMethod(ejbMethodIdentifier);
            }
            klass = this.getSuperClass(klass, index);
        }
    }
}

