/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class RemoveAnnotationProcessor
extends AbstractAnnotationEJBProcessor<StatefulComponentDescription> {
    private static final DotName REMOVE_ANNOTATION_DOT_NAME = DotName.createSimple((String)Remove.class.getName());

    @Override
    protected Class<StatefulComponentDescription> getComponentDescriptionType() {
        return StatefulComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, StatefulComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        List removeAnnotations = (List)annotationsOnBean.get(REMOVE_ANNOTATION_DOT_NAME);
        if (removeAnnotations == null || removeAnnotations.isEmpty()) {
            return;
        }
        for (AnnotationInstance removeAnnotation : removeAnnotations) {
            MethodInfo targetMethod = (MethodInfo)removeAnnotation.target();
            MethodIdentifier removeMethod = MethodIdentifier.getIdentifier((String)targetMethod.returnType().toString(), (String)targetMethod.name(), (String[])RemoveAnnotationProcessor.toString(targetMethod.args()));
            AnnotationValue retainIfExceptionAnnValue = removeAnnotation.value("retainIfException");
            boolean retainIfException = false;
            if (retainIfExceptionAnnValue != null) {
                retainIfException = retainIfExceptionAnnValue.asBoolean();
            }
            componentDescription.addRemoveMethod(removeMethod, retainIfException);
        }
    }

    private static String[] toString(Object[] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].toString();
        }
        return result;
    }
}

