/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;
import org.jboss.metadata.javaee.spec.Environment;

public class SessionBeanXmlDescriptorProcessor
extends AbstractEjbXmlDescriptorProcessor<SessionBeanMetaData> {
    private static final Logger logger = Logger.getLogger(SessionBeanXmlDescriptorProcessor.class);

    @Override
    protected Class<SessionBeanMetaData> getMetaDataType() {
        return SessionBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(SessionBeanMetaData sessionBean, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ContainerTransactionsMetaData containerTransactions;
        BusinessRemotesMetaData businessRemotes;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String applicationName = moduleDescription.getApplicationName();
        String beanName = sessionBean.getName();
        SessionBeanComponentDescription sessionBeanDescription = (SessionBeanComponentDescription)moduleDescription.getComponentByName(beanName);
        sessionBeanDescription.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (Environment)sessionBean));
        sessionBeanDescription.setMappedName(sessionBean.getMappedName());
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        if (businessLocals != null && !businessLocals.isEmpty()) {
            sessionBeanDescription.addLocalBusinessInterfaceViews((Collection<String>)businessLocals);
        }
        if ((businessRemotes = sessionBean.getBusinessRemotes()) != null && !businessRemotes.isEmpty()) {
            sessionBeanDescription.addRemoteBusinessInterfaceViews((Collection<String>)businessRemotes);
        }
        if (sessionBean.getTransactionType() != null) {
            sessionBeanDescription.setTransactionManagementType(sessionBean.getTransactionType());
        }
        if (sessionBean.getTransactionType() != TransactionManagementType.BEAN && (containerTransactions = sessionBean.getContainerTransactions()) != null && !containerTransactions.isEmpty()) {
            String className = null;
            for (ContainerTransactionMetaData containerTx : containerTransactions) {
                TransactionAttributeType txAttr = containerTx.getTransAttribute();
                MethodsMetaData methods = containerTx.getMethods();
                for (MethodMetaData method : methods) {
                    String methodName = method.getMethodName();
                    MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf());
                    if (methodName.equals("*")) {
                        sessionBeanDescription.setTransactionAttribute(methodIntf, className, txAttr);
                        continue;
                    }
                    MethodParametersMetaData methodParams = method.getMethodParams();
                    sessionBeanDescription.setTransactionAttribute(methodIntf, txAttr, className, methodName, this.getMethodParams(methodParams));
                }
            }
        }
        this.processInterceptors(sessionBean, sessionBeanDescription, applicationClassesDescription);
        if (sessionBean instanceof SessionBean31MetaData) {
            this.processSessionBean31((SessionBean31MetaData)sessionBean, sessionBeanDescription);
        }
    }

    private static void processSessionSynchronization(SessionBean31MetaData metaData, SessionBeanComponentDescription sessionBeanComponentDescription) {
        if (!(sessionBeanComponentDescription instanceof StatefulComponentDescription)) {
            return;
        }
        StatefulComponentDescription description = (StatefulComponentDescription)sessionBeanComponentDescription;
        if (metaData.getAfterBeginMethod() != null) {
            description.setAfterBegin(null, metaData.getAfterBeginMethod().getMethodName());
        }
        if (metaData.getAfterCompletionMethod() != null) {
            description.setAfterCompletion(null, metaData.getAfterCompletionMethod().getMethodName());
        }
        if (metaData.getBeforeCompletionMethod() != null) {
            description.setBeforeCompletion(null, metaData.getBeforeCompletionMethod().getMethodName());
        }
    }

    protected void processInterceptors(SessionBeanMetaData enterpriseBean, EJBComponentDescription ejbComponentDescription, EEApplicationClasses applicationClassesDescription) {
        MethodIdentifier identifier;
        EEModuleClassDescription interceptorModuleClassDescription;
        if (enterpriseBean.getAroundInvokes() != null) {
            for (AroundInvokeMetaData interceptor : enterpriseBean.getAroundInvokes()) {
                if (interceptor.getClassName() == null) {
                    ejbComponentDescription.getAroundInvokeDDMethods().add(interceptor.getMethodName());
                    continue;
                }
                interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptor.getClassName());
                identifier = MethodIdentifier.getIdentifier(Object.class, (String)interceptor.getMethodName(), (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setAroundInvokeMethod(identifier);
            }
        }
        if (enterpriseBean.getPreDestroys() != null) {
            for (AroundInvokeMetaData interceptor : enterpriseBean.getPreDestroys()) {
                if (interceptor.getClassName() == null) {
                    ejbComponentDescription.getPreDestroyDDMethods().add(interceptor.getMethodName());
                    continue;
                }
                interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptor.getClassName());
                identifier = MethodIdentifier.getIdentifier(Object.class, (String)interceptor.getMethodName(), (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setPreDestroyMethod(identifier);
            }
        }
        if (enterpriseBean.getPostConstructs() != null) {
            for (AroundInvokeMetaData interceptor : enterpriseBean.getPostConstructs()) {
                if (interceptor.getClassName() == null) {
                    ejbComponentDescription.getPostConstructDDMethods().add(interceptor.getMethodName());
                    continue;
                }
                interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptor.getClassName());
                identifier = MethodIdentifier.getIdentifier(Object.class, (String)interceptor.getMethodName(), (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setPostConstructMethod(identifier);
            }
        }
    }

    private void processSessionBean31(SessionBean31MetaData sessionBean31MetaData, SessionBeanComponentDescription sessionBeanComponentDescription) {
        if (sessionBean31MetaData.isNoInterfaceBean()) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
        if (sessionBean31MetaData.isSingleton() && sessionBeanComponentDescription instanceof SingletonComponentDescription) {
            this.processSingletonBean(sessionBean31MetaData, (SingletonComponentDescription)sessionBeanComponentDescription);
        }
        if (sessionBean31MetaData.isStateful() && sessionBeanComponentDescription instanceof StatefulComponentDescription) {
            this.processStatefulBean(sessionBean31MetaData, (StatefulComponentDescription)sessionBeanComponentDescription);
        }
        SessionBeanXmlDescriptorProcessor.processSessionSynchronization(sessionBean31MetaData, sessionBeanComponentDescription);
    }

    private void processStatefulBean(SessionBean31MetaData sessionBean31MetaData, StatefulComponentDescription sessionBeanComponentDescription) {
        StatefulTimeoutMetaData statefulTimeout = sessionBean31MetaData.getStatefulTimeout();
        if (statefulTimeout != null) {
            TimeUnit unit = TimeUnit.MINUTES;
            if (statefulTimeout.getUnit() != null) {
                unit = statefulTimeout.getUnit();
            }
            sessionBeanComponentDescription.setStatefulTimeout(new StatefulTimeoutInfo(statefulTimeout.getTimeout(), unit));
        }
    }

    private void processSingletonBean(SessionBean31MetaData singletonBeanMetaData, SingletonComponentDescription singletonComponentDescription) {
        Boolean initOnStartup = singletonBeanMetaData.isInitOnStartup();
        if (initOnStartup != null && initOnStartup.booleanValue()) {
            singletonComponentDescription.initOnStartup();
        }
        LockType lockType = singletonBeanMetaData.getLockType();
        singletonComponentDescription.setBeanLevelLockType(singletonComponentDescription.getEJBClassName(), lockType);
        ConcurrencyManagementType concurrencyManagementType = singletonBeanMetaData.getConcurrencyManagementType();
        if (concurrencyManagementType == ConcurrencyManagementType.BEAN) {
            singletonComponentDescription.beanManagedConcurrency();
        } else {
            singletonComponentDescription.containerManagedConcurrency();
        }
        AccessTimeoutMetaData accessTimeoutMetaData = singletonBeanMetaData.getAccessTimeout();
        if (accessTimeoutMetaData != null) {
            final long timeout = accessTimeoutMetaData.getTimeout();
            final TimeUnit unit = accessTimeoutMetaData.getUnit();
            AccessTimeout accessTimeout = new AccessTimeout(){

                public long value() {
                    return timeout;
                }

                public TimeUnit unit() {
                    return unit;
                }

                public Class<? extends Annotation> annotationType() {
                    return AccessTimeout.class;
                }
            };
            singletonComponentDescription.setBeanLevelAccessTimeout(singletonComponentDescription.getEJBClassName(), accessTimeout);
        }
    }
}

