/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Digest
implements Externalizable,
Streamable {
    public static final Digest EMPTY_DIGEST = new Digest();
    protected final Map<Address, Entry> senders;
    protected static final Log log = LogFactory.getLog(Digest.class);
    private static final long serialVersionUID = 6611464897656359215L;

    public Digest() {
        this.senders = Digest.createSenders(7);
    }

    public Digest(int size) {
        this.senders = Digest.createSenders(size);
    }

    public Digest(Map<Address, Entry> map) {
        this.senders = Digest.createSenders(map);
    }

    public Digest(Digest d) {
        this(d.senders);
    }

    public Digest(Address sender, long low, long highest_delivered, long highest_received) {
        this.senders = Digest.createSenders(1);
        this.senders.put(sender, new Entry(low, highest_delivered, highest_received));
    }

    public Digest(Address sender, long low, long highest_delivered) {
        this.senders = Digest.createSenders(1);
        this.senders.put(sender, new Entry(low, highest_delivered));
    }

    public Map<Address, Entry> getSenders() {
        return Collections.unmodifiableMap(this.senders);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Digest)) {
            return false;
        }
        Digest other = (Digest)obj;
        return ((Object)this.senders).equals(other.senders);
    }

    public boolean contains(Address sender) {
        return this.senders.containsKey(sender);
    }

    public Entry get(Address sender) {
        return this.senders.get(sender);
    }

    public boolean sameSenders(Digest other) {
        if (other == null) {
            return false;
        }
        if (this.senders.size() != other.senders.size()) {
            return false;
        }
        Set<Address> my_senders = this.senders.keySet();
        Set<Address> other_senders = other.senders.keySet();
        return ((Object)my_senders).equals(other_senders);
    }

    public Digest difference(Digest other) {
        if (other == null) {
            return this.copy();
        }
        Digest result = EMPTY_DIGEST;
        if (this.equals(other)) {
            return result;
        }
        ConcurrentHashMap<Address, Entry> resultMap = new ConcurrentHashMap<Address, Entry>(7);
        TreeSet<Address> intersection = new TreeSet<Address>(this.senders.keySet());
        intersection.retainAll(other.senders.keySet());
        for (Address address : intersection) {
            Entry e1 = this.get(address);
            Entry e2 = other.get(address);
            if (e1.getHighestDeliveredSeqno() == e2.getHighestDeliveredSeqno()) continue;
            long low = Math.min(e1.highest_delivered_seqno, e2.highest_delivered_seqno);
            long high = Math.max(e1.highest_delivered_seqno, e2.highest_delivered_seqno);
            Entry r = new Entry(low, high);
            resultMap.put(address, r);
        }
        if (intersection.size() != this.senders.keySet().size()) {
            TreeSet<Address> thisMinusInteresection = new TreeSet<Address>(this.senders.keySet());
            thisMinusInteresection.removeAll(intersection);
            for (Address address : thisMinusInteresection) {
                resultMap.put(address, new Entry(this.get(address)));
            }
        }
        if (intersection.size() != other.senders.keySet().size()) {
            TreeSet<Address> otherMinusInteresection = new TreeSet<Address>(other.senders.keySet());
            otherMinusInteresection.removeAll(intersection);
            for (Address address : otherMinusInteresection) {
                resultMap.put(address, new Entry(other.get(address)));
            }
        }
        result = new Digest(resultMap);
        return result;
    }

    public Digest highestSequence(Digest other) {
        if (other == null) {
            return this.copy();
        }
        Digest result = EMPTY_DIGEST;
        if (this.equals(other)) {
            return this;
        }
        ConcurrentHashMap<Address, Entry> resultMap = new ConcurrentHashMap<Address, Entry>(7);
        TreeSet<Address> intersection = new TreeSet<Address>(this.senders.keySet());
        intersection.retainAll(other.senders.keySet());
        for (Address address : intersection) {
            Entry e1 = this.get(address);
            Entry e2 = other.get(address);
            long high = Math.max(e1.highest_delivered_seqno, e2.highest_delivered_seqno);
            Entry r = new Entry(0L, high);
            resultMap.put(address, r);
        }
        if (intersection.size() != this.senders.keySet().size()) {
            TreeSet<Address> thisMinusInteresection = new TreeSet<Address>(this.senders.keySet());
            thisMinusInteresection.removeAll(intersection);
            for (Address address : thisMinusInteresection) {
                resultMap.put(address, new Entry(this.get(address)));
            }
        }
        if (intersection.size() != other.senders.keySet().size()) {
            TreeSet<Address> otherMinusInteresection = new TreeSet<Address>(other.senders.keySet());
            otherMinusInteresection.removeAll(intersection);
            for (Address address : otherMinusInteresection) {
                resultMap.put(address, new Entry(other.get(address)));
            }
        }
        result = new Digest(resultMap);
        return result;
    }

    public int size() {
        return this.senders.size();
    }

    public long lowSeqnoAt(Address sender) {
        Entry entry = this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.low_seqno;
    }

    public long highestDeliveredSeqnoAt(Address sender) {
        Entry entry = this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.highest_delivered_seqno;
    }

    public long highestReceivedSeqnoAt(Address sender) {
        Entry entry = this.senders.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry.highest_received_seqno;
    }

    public boolean isGreaterThanOrEqual(Digest other) {
        if (other == null) {
            return true;
        }
        Map<Address, Entry> our_map = this.getSenders();
        for (Map.Entry<Address, Entry> entry : our_map.entrySet()) {
            long their_highest;
            long my_highest;
            Address sender = entry.getKey();
            Entry my_entry = entry.getValue();
            Entry their_entry = other.get(sender);
            if (their_entry == null || (my_highest = my_entry.getHighest()) >= (their_highest = their_entry.getHighest())) continue;
            return false;
        }
        return true;
    }

    public Digest copy() {
        return new Digest(this.senders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.senders.isEmpty()) {
            return "[]";
        }
        for (Map.Entry<Address, Entry> entry : this.senders.entrySet()) {
            Address key = entry.getKey();
            Entry val = entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(val.low_seqno).append(" : ");
            sb.append(val.highest_delivered_seqno);
            if (val.highest_received_seqno >= 0L) {
                sb.append(" (").append(val.highest_received_seqno).append(")");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String toStringSorted() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.senders.isEmpty()) {
            return "[]";
        }
        TreeMap<Address, Entry> copy = new TreeMap<Address, Entry>(this.senders);
        for (Map.Entry<Address, Entry> entry : copy.entrySet()) {
            Address key = entry.getKey();
            Entry val = entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(val.low_seqno).append(" : ");
            sb.append(val.highest_delivered_seqno);
            if (val.highest_received_seqno >= 0L) {
                sb.append(" (").append(val.highest_received_seqno).append(")");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String printHighestDeliveredSeqnos() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        TreeMap<Address, Entry> copy = new TreeMap<Address, Entry>(this.senders);
        for (Map.Entry<Address, Entry> entry : copy.entrySet()) {
            Address key = entry.getKey();
            Entry val = entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append("#").append(val.highest_delivered_seqno);
        }
        sb.append(']');
        return sb.toString();
    }

    public String printHighestReceivedSeqnos() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Address, Entry> entry : this.senders.entrySet()) {
            Address key = entry.getKey();
            Entry val = entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                sb.append('[');
                first = false;
            }
            sb.append(key).append("#").append(val.highest_received_seqno);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.senders);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map tmp = (Map)in.readObject();
        this.senders.clear();
        this.senders.putAll(tmp);
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeShort(this.senders.size());
        for (Map.Entry<Address, Entry> entry : this.senders.entrySet()) {
            Entry val = entry.getValue();
            Util.writeAddress(entry.getKey(), out);
            out.writeLong(val.low_seqno);
            out.writeLong(val.highest_delivered_seqno);
            out.writeLong(val.highest_received_seqno);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int size = in.readShort();
        HashMap<Address, Entry> tmp = new HashMap<Address, Entry>(size);
        for (int i = 0; i < size; ++i) {
            Address key = Util.readAddress(in);
            tmp.put(key, new Entry(in.readLong(), in.readLong(), in.readLong()));
        }
        this.senders.clear();
        this.senders.putAll(tmp);
    }

    public long serializedSize() {
        long retval = 2L;
        if (!this.senders.isEmpty()) {
            Address addr = this.senders.keySet().iterator().next();
            int len = Util.size(addr);
            retval += (long)((len += 24) * this.senders.size());
        }
        return retval;
    }

    private static Map<Address, Entry> createSenders(int size) {
        return new ConcurrentHashMap<Address, Entry>(size);
    }

    private static Map<Address, Entry> createSenders(Map<Address, Entry> map) {
        return new ConcurrentHashMap<Address, Entry>(map);
    }

    public static class Entry
    implements Externalizable,
    Streamable {
        private long low_seqno = 0L;
        private long highest_delivered_seqno = 0L;
        private long highest_received_seqno = 0L;
        static final int SIZE = 24;
        private static final long serialVersionUID = -4468945932249281704L;

        public Entry() {
        }

        public Entry(long low_seqno, long highest_delivered_seqno, long highest_received_seqno) {
            this.low_seqno = low_seqno;
            this.highest_delivered_seqno = highest_delivered_seqno;
            this.highest_received_seqno = highest_received_seqno;
            this.check();
        }

        public Entry(long low_seqno, long highest_delivered_seqno) {
            this.low_seqno = low_seqno;
            this.highest_delivered_seqno = highest_delivered_seqno;
            this.check();
        }

        public Entry(Entry other) {
            if (other != null) {
                this.low_seqno = other.low_seqno;
                this.highest_delivered_seqno = other.highest_delivered_seqno;
                this.highest_received_seqno = other.highest_received_seqno;
                this.check();
            }
        }

        public final long getLow() {
            return this.low_seqno;
        }

        public final long getHighestDeliveredSeqno() {
            return this.highest_delivered_seqno;
        }

        public final long getHighestReceivedSeqno() {
            return this.highest_received_seqno;
        }

        public final long getHighest() {
            return Math.max(this.highest_delivered_seqno, this.highest_received_seqno);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.low_seqno == other.low_seqno && this.highest_delivered_seqno == other.highest_delivered_seqno && this.highest_received_seqno == other.highest_received_seqno;
        }

        public int hashCode() {
            return (int)(this.low_seqno + this.highest_delivered_seqno + this.highest_received_seqno);
        }

        public String toString() {
            return "low=" + this.low_seqno + ", highest delivered=" + this.highest_delivered_seqno + ", highest received=" + this.highest_received_seqno;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.low_seqno);
            out.writeLong(this.highest_delivered_seqno);
            out.writeLong(this.highest_received_seqno);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.low_seqno = in.readLong();
            this.highest_delivered_seqno = in.readLong();
            this.highest_received_seqno = in.readLong();
        }

        public static int size() {
            return 24;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeLong(this.low_seqno);
            out.writeLong(this.highest_delivered_seqno);
            out.writeLong(this.highest_received_seqno);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.low_seqno = in.readLong();
            this.highest_delivered_seqno = in.readLong();
            this.highest_received_seqno = in.readLong();
        }

        private void check() {
            if (this.low_seqno > this.highest_delivered_seqno) {
                throw new IllegalArgumentException("low_seqno (" + this.low_seqno + ") is greater than highest_delivered_seqno (" + this.highest_delivered_seqno + ")");
            }
        }
    }
}

