/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;

public class EEClassConfigurationProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EEClassConfigurationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (moduleDescription == null) {
            return;
        }
        if (module == null) {
            return;
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        if (deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.DEPLOYMENT_TYPE) == DeploymentType.EAR) {
            HashSet<String> processed = new HashSet<String>();
            List subdeployments = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit subdeployment : subdeployments) {
                this.processClasses(phaseContext, applicationDescription, deploymentReflectionIndex, subdeployment, processed);
            }
            this.processClasses(phaseContext, applicationDescription, deploymentReflectionIndex, deploymentUnit, processed);
        } else if (deploymentUnit.getParent() == null) {
            if (moduleDescription == null) {
                return;
            }
            Collection<EEModuleClassDescription> classDescriptions = applicationClasses.getClassDescriptions();
            if (classDescriptions != null) {
                for (EEModuleClassDescription classDescription : classDescriptions) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(classDescription.getClassName(), false, (ClassLoader)module.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentUnitProcessingException("Failed to load class " + classDescription.getClassName(), (Throwable)e);
                    }
                    EEModuleClassConfiguration classConfiguration = new EEModuleClassConfiguration(clazz, classDescription, deploymentReflectionIndex);
                    logger.debug((Object)("Configuring EE module class: " + clazz));
                    for (ClassConfigurator classConfigurator : classDescription.getConfigurators()) {
                        classConfigurator.configure(phaseContext, classDescription, classConfiguration);
                    }
                    applicationDescription.addClass(classConfiguration);
                }
            }
        }
    }

    private void processClasses(DeploymentPhaseContext phaseContext, EEApplicationDescription applicationDescription, DeploymentReflectionIndex deploymentReflectionIndex, DeploymentUnit subdeployment, Set<String> processed) throws DeploymentUnitProcessingException {
        EEModuleDescription subModuleDescription = (EEModuleDescription)subdeployment.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (subModuleDescription == null) {
            return;
        }
        Module subModule = (Module)subdeployment.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)subdeployment.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Collection<EEModuleClassDescription> classDescriptions = applicationClasses.getClassDescriptions();
        if (classDescriptions != null) {
            for (EEModuleClassDescription classDescription : classDescriptions) {
                if (processed.contains(classDescription.getClassName())) continue;
                processed.add(classDescription.getClassName());
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(classDescription.getClassName(), false, (ClassLoader)subModule.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Failed to load class " + classDescription.getClassName(), (Throwable)e);
                }
                EEModuleClassConfiguration classConfiguration = new EEModuleClassConfiguration(clazz, classDescription, deploymentReflectionIndex);
                logger.debug((Object)("Configuring EE module class: " + clazz));
                for (ClassConfigurator classConfigurator : classDescription.getConfigurators()) {
                    classConfigurator.configure(phaseContext, classDescription, classConfiguration);
                }
                applicationDescription.addClass(classConfiguration);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

