/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWebConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();

    @Override
    public Collection<URL> getResources(ServletContext context) {
        WebConfiguration webConfig = WebConfiguration.getInstance(context);
        String paths = webConfig.getOptionValue(this.getParameter());
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>(6);
        if (paths != null) {
            for (String token : Util.split(context, paths.trim(), this.getSeparatorRegex())) {
                String path = token.trim();
                if (this.isExcluded(path) || path.length() == 0) continue;
                URL u = this.getContextURLForPath(context, path);
                if (u != null) {
                    urls.add(u);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "jsf.config.web_resource_not_found", new Object[]{path, WebConfiguration.WebContextInitParameter.JavaxFacesConfigFiles.getQualifiedName()});
            }
        }
        return urls;
    }

    protected abstract WebConfiguration.WebContextInitParameter getParameter();

    protected abstract String[] getExcludedResources();

    protected abstract String getSeparatorRegex();

    protected URL getContextURLForPath(ServletContext context, String path) {
        try {
            return context.getResource(path);
        }
        catch (MalformedURLException mue) {
            throw new FacesException((Throwable)mue);
        }
    }

    protected boolean isExcluded(String path) {
        return Arrays.binarySearch(this.getExcludedResources(), path) >= 0;
    }
}

