/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResolverCallback;
import org.jboss.osgi.resolver.XResolverException;
import org.jboss.osgi.resolver.XResolverFactory;
import org.jboss.osgi.resolver.XWire;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class ResolverPlugin
extends AbstractPluginService<ResolverPlugin> {
    final Logger log = Logger.getLogger(ResolverPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private final InjectedValue<NativeCodePlugin> injectedNativeCode = new InjectedValue();
    private final XResolverFactory factory = XResolverFactory.getInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    private XResolver resolver;

    static void addService(ServiceTarget serviceTarget) {
        ResolverPlugin service = new ResolverPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.RESOLVER_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, service.injectedModuleManager);
        builder.addDependency(InternalServices.NATIVE_CODE_PLUGIN, NativeCodePlugin.class, service.injectedNativeCode);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private ResolverPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.resolver = this.factory.newResolver();
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.resolver = null;
    }

    public ResolverPlugin getValue() {
        return this;
    }

    XResolver getResolver() {
        return this.resolver;
    }

    XModuleBuilder getModuleBuilder() {
        return this.factory.newModuleBuilder();
    }

    void addModule(XModule resModule) {
        this.resolver.addModule(resModule);
    }

    void removeModule(XModule resModule) {
        this.resolver.removeModule(resModule);
    }

    XModule getModuleById(XModuleIdentity moduleId) {
        return this.resolver != null ? this.resolver.getModuleById(moduleId) : null;
    }

    void resolve(XModule resModule) throws BundleException {
        ArrayList<XModule> resolved = new ArrayList<XModule>();
        this.resolver.setCallbackHandler((XResolverCallback)new ResolverCallback(resolved));
        try {
            this.resolver.resolve(resModule);
        }
        catch (XResolverException ex) {
            throw new BundleException("Cannot resolve bundle resModule: " + resModule, (Throwable)ex);
        }
        this.applyResolverResults(resolved);
    }

    boolean resolveAll(Set<XModule> unresolved) {
        if (unresolved == null) {
            unresolved = new HashSet<XModule>();
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            Set<AbstractBundleState> allBundles = bundleManager.getBundles();
            for (AbstractBundleState bundleState : allBundles) {
                XModule auxModule;
                XModuleIdentity moduleId;
                if (bundleState.getState() != 2 || this.getModuleById(moduleId = (auxModule = bundleState.getResolverModule()).getModuleId()) == null) continue;
                unresolved.add(auxModule);
            }
        }
        ArrayList<XModule> resolved = new ArrayList<XModule>();
        this.resolver.setCallbackHandler((XResolverCallback)new ResolverCallback(resolved));
        this.log.debugf("Resolve modules: %s", unresolved);
        boolean allResolved = this.resolver.resolveAll(unresolved);
        if (!allResolved) {
            for (XModule resModule : unresolved) {
                if (resModule.isResolved()) continue;
                XResolverException ex = (XResolverException)((Object)resModule.getAttachment(XResolverException.class));
                this.log.errorf((Throwable)ex, "Cannot resolve: %s", (Object)resModule);
            }
        }
        try {
            this.applyResolverResults(resolved);
        }
        catch (BundleException ex) {
            this.log.debugf((Throwable)ex, "Exception when applying resolver results.", new Object[0]);
            allResolved = false;
        }
        return allResolved;
    }

    private void applyResolverResults(List<XModule> resolved) throws BundleException {
        this.attachFragmentsToHost(resolved);
        this.resolveNativeCodeLibraries(resolved);
        this.addModules(resolved);
        this.loadModules(resolved);
        this.setBundleToResolved(resolved);
    }

    private void attachFragmentsToHost(List<XModule> resolved) {
        for (XModule aux : resolved) {
            if (!aux.isFragment()) continue;
            FragmentBundleRevision fragRev = (FragmentBundleRevision)aux.getAttachment(AbstractBundleRevision.class);
            fragRev.attachToHost();
        }
    }

    private void addModules(List<XModule> resolved) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue());
        for (XModule aux : resolved) {
            if (aux.isFragment()) continue;
            moduleManager.addModule(aux);
        }
    }

    private void loadModules(List<XModule> resolved) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue());
        for (XModule aux : resolved) {
            if (aux.isFragment()) continue;
            ModuleIdentifier identifier = moduleManager.getModuleIdentifier(aux);
            try {
                moduleManager.loadModule(identifier);
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException("Cannot load module: " + identifier, ex);
            }
        }
    }

    private void resolveNativeCodeLibraries(List<XModule> resolved) throws BundleException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        XModule systemModule = bundleManager.getSystemBundle().getResolverModule();
        for (XModule aux : resolved) {
            Bundle bundle;
            UserBundleState userBundle;
            Deployment deployment;
            NativeLibraryMetaData libMetaData;
            if (aux == systemModule || (libMetaData = (NativeLibraryMetaData)(deployment = (userBundle = UserBundleState.assertBundleState(bundle = (Bundle)aux.getAttachment(Bundle.class))).getDeployment()).getAttachment(NativeLibraryMetaData.class)) == null) continue;
            NativeCodePlugin nativeCodePlugin = (NativeCodePlugin)((Object)this.injectedNativeCode.getValue());
            nativeCodePlugin.resolveNativeCode(userBundle);
        }
    }

    private void setBundleToResolved(List<XModule> resolved) {
        for (XModule aux : resolved) {
            Bundle bundle = (Bundle)aux.getAttachment(Bundle.class);
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
            bundleState.changeState(4);
        }
    }

    class ResolverCallback
    implements XResolverCallback {
        private List<XModule> resolved;

        ResolverCallback(List<XModule> resolved) {
            this.resolved = resolved;
        }

        public void markResolved(XModule module) {
            if (ResolverPlugin.this.log.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer("Mark resolved: " + module);
                for (XWire wire : module.getWires()) {
                    buffer.append("\n " + wire.toString());
                }
                ResolverPlugin.this.log.debugf(buffer.toString(), new Object[0]);
            }
            this.resolved.add(module);
        }
    }
}

