/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashSet;
import java.util.List;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class JMSQueueAdd
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    public static final JMSQueueAdd INSTANCE = new JMSQueueAdd();
    private static final String[] NO_BINDINGS = new String[0];

    public static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (existing.hasDefined("selector")) {
            op.get("selector").set(existing.get("selector"));
        }
        if (existing.hasDefined("durable")) {
            op.get("durable").set(existing.get("durable"));
        }
        if (existing.hasDefined("entries")) {
            op.get("entries").set(existing.get("entries"));
        }
        return op;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        if (operation.hasDefined("selector")) {
            String selector = operation.get("selector").asString();
            model.get("selector").set(selector);
        } else {
            Object selector = null;
        }
        if (operation.hasDefined("durable")) {
            model.get("durable").set(operation.get("durable"));
        }
        if (operation.hasDefined("entries")) {
            model.get("entries").set(operation.get("entries"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String selector = operation.hasDefined("selector") ? operation.get("selector").asString() : null;
        JMSQueueService service = new JMSQueueService(name, selector, operation.get("durable").asBoolean(true), JMSQueueAdd.jndiBindings(operation));
        ServiceName serviceName = JMSServices.JMS_QUEUE_BASE.append(new String[]{name});
        newControllers.add(context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static String[] jndiBindings(ModelNode node) {
        if (node.hasDefined("entries")) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get("entries").asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }
}

