/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigProperties;
import org.jboss.as.messaging.jms.PooledConnectionFactoryService;
import org.jboss.as.txn.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class PooledConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final PooledConnectionFactoryAdd INSTANCE = new PooledConnectionFactoryAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (JMSServices.NodeAttribute attribute : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            String attrName = attribute.getName();
            if (!subModel.has(attrName)) continue;
            operation.get(attrName).set(subModel.get(attrName));
        }
        return operation;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.hasDefined("entries")) {
            List entries = operation.get("entries").asList();
            if (entries.size() == 0) {
                throw new OperationFailedException("at least 1 jndi entry should be provided", operation);
            }
        } else {
            throw new OperationFailedException("at least 1 jndi entry should be provided", operation);
        }
        for (JMSServices.NodeAttribute attribute : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attribute.getName();
            if (!operation.hasDefined(attrName)) continue;
            model.get(attrName).set(operation.get(attrName));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String txType;
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        String jndiName = ((ModelNode)operation.get("entries").asList().get(0)).asString();
        String txSupport = operation.hasDefined("transaction") ? ("local".equals(txType = operation.get("transaction").asString()) ? "LocalTransaction" : ("none".equals(txType) ? "NoTransaction" : "XATransaction")) : "XATransaction";
        ServiceTarget serviceTarget = context.getServiceTarget();
        List<String> connectors = PooledConnectionFactoryAdd.getConnectors(operation);
        List<PooledConnectionFactoryConfigProperties> adapterParams = PooledConnectionFactoryAdd.getAdapterParams(operation);
        ServiceName hornetQResourceAdapterService = MessagingServices.POOLED_CONNECTION_FACTORY_BASE.append(new String[]{name});
        PooledConnectionFactoryService resourceAdapterService = new PooledConnectionFactoryService(name, connectors, adapterParams, jndiName, txSupport);
        ServiceBuilder serviceBuilder = serviceTarget.addService(hornetQResourceAdapterService, (Service)resourceAdapterService).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, resourceAdapterService.getTransactionManager()).addDependency(MessagingServices.JBOSS_MESSAGING, HornetQServer.class, resourceAdapterService.getHornetQService()).addListener((ServiceListener)verificationHandler);
        newControllers.add(serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static List<String> getConnectors(ModelNode operation) {
        ArrayList<String> connectorNames = new ArrayList<String>();
        if (operation.hasDefined("connector")) {
            for (String connectorName : operation.get("connector").keys()) {
                connectorNames.add(connectorName);
            }
        }
        return connectorNames;
    }

    static List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode operation) {
        ArrayList<PooledConnectionFactoryConfigProperties> configs = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (JMSServices.PooledCFAttribute nodeAttribute : JMSServices.POOLED_CONNECTION_FACTORY_METHOD_ATTRS) {
            if (!operation.hasDefined(nodeAttribute.getName())) continue;
            String value = operation.get(nodeAttribute.getName()).asString();
            configs.add(new PooledConnectionFactoryConfigProperties(nodeAttribute.getMethodName(), value, nodeAttribute.getClassType()));
        }
        return configs;
    }
}

