/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.impl.DefaultParsedArguments;
import org.jboss.as.cli.parsing.CommandLineParser;

public abstract class BaseArgumentTabCompleter
implements CommandLineCompleter {
    private final ParsingResults results = new ParsingResults();

    @Override
    public int complete(CommandContext ctx, final String buffer, int cursor, List<String> candidates) {
        int firstCharIndex;
        for (firstCharIndex = 0; firstCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(firstCharIndex)); ++firstCharIndex) {
        }
        this.results.reset();
        final DefaultParsedArguments parsedArguments = (DefaultParsedArguments)ctx.getParsedArguments();
        parsedArguments.reset(null, null);
        try {
            CommandLineParser.parse(buffer, new CommandLineParser.CallbackHandler(){

                @Override
                public void argument(String name, int nameStart, String value, int valueStart, int end) throws CommandFormatException {
                    if (end > 0 && end < buffer.length()) {
                        parsedArguments.argument(name, nameStart, value, valueStart, end);
                    }
                    ((BaseArgumentTabCompleter)BaseArgumentTabCompleter.this).results.argName = name;
                    ((BaseArgumentTabCompleter)BaseArgumentTabCompleter.this).results.argValue = value;
                    ((BaseArgumentTabCompleter)BaseArgumentTabCompleter.this).results.nameStart = nameStart;
                    ((BaseArgumentTabCompleter)BaseArgumentTabCompleter.this).results.valueStart = valueStart;
                    ((BaseArgumentTabCompleter)BaseArgumentTabCompleter.this).results.endIndex = end;
                }
            });
        }
        catch (CommandLineException e) {
            return -1;
        }
        int result = buffer.length();
        String chunk = null;
        CommandLineCompleter valueCompleter = null;
        if (firstCharIndex != result) {
            if (this.results.argValue != null) {
                if (this.results.argValue.isEmpty()) {
                    chunk = null;
                    result = this.results.valueStart;
                    valueCompleter = this.getValueCompleter(ctx, this.results.argName);
                    if (valueCompleter == null) {
                        return -1;
                    }
                } else if (this.results.endIndex < buffer.length()) {
                    chunk = null;
                } else {
                    chunk = this.results.argValue;
                    result = this.results.valueStart;
                    valueCompleter = this.getValueCompleter(ctx, this.results.argName);
                    if (valueCompleter == null) {
                        return -1;
                    }
                }
            } else if (this.results.endIndex < buffer.length()) {
                chunk = null;
            } else {
                chunk = this.results.argName;
                if (this.results.argName != null) {
                    result = this.results.nameStart;
                }
            }
        }
        if (valueCompleter != null) {
            int valueResult = valueCompleter.complete(ctx, chunk == null ? "" : chunk, cursor, candidates);
            if (valueResult < 0) {
                return valueResult;
            }
            return result + valueResult;
        }
        for (CommandArgument arg : this.getAllArguments(ctx)) {
            try {
                if (!arg.canAppearNext(ctx)) continue;
                if (arg.getIndex() >= 0) {
                    CommandLineCompleter valCompl = arg.getValueCompleter();
                    if (valCompl == null) continue;
                    valCompl.complete(ctx, chunk == null ? "" : chunk, cursor, candidates);
                    continue;
                }
                String argName = arg.getFullName();
                if (chunk == null) {
                    if (arg.isValueRequired()) {
                        argName = argName + '=';
                    }
                    candidates.add(argName);
                    continue;
                }
                if (!argName.startsWith(chunk)) continue;
                if (arg.isValueRequired()) {
                    argName = argName + '=';
                }
                candidates.add(argName);
            }
            catch (CommandFormatException e) {
                return -1;
            }
        }
        Collections.sort(candidates);
        return result;
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, String argName) {
        if (argName != null) {
            for (CommandArgument arg : this.getAllArguments(ctx)) {
                if (!argName.equals(arg.getFullName())) continue;
                return arg.getValueCompleter();
            }
            return null;
        }
        for (CommandArgument arg : this.getAllArguments(ctx)) {
            try {
                if (arg.getIndex() < 0 || !arg.canAppearNext(ctx)) continue;
                return arg.getValueCompleter();
            }
            catch (CommandFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected abstract Iterable<CommandArgument> getAllArguments(CommandContext var1);

    private static final class ParsingResults {
        String argName;
        String argValue;
        int nameStart;
        int valueStart;
        int endIndex;

        private ParsingResults() {
        }

        void reset() {
            this.argName = null;
            this.argValue = null;
            this.nameStart = -1;
            this.valueStart = -1;
            this.endIndex = -1;
        }
    }
}

