/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class ThreadFactoryAdd
implements OperationStepHandler,
DescriptionProvider {
    static final ThreadFactoryAdd INSTANCE = new ThreadFactoryAdd();

    public void execute(OperationContext context, ModelNode operation) {
        int priority;
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        final String groupName = operation.hasDefined("group-name") ? operation.get("group-name").asString() : null;
        final String threadNamePattern = operation.hasDefined("thread-name-pattern") ? operation.get("thread-name-pattern").asString() : null;
        int n = priority = operation.hasDefined("priority") ? operation.get("priority").asInt() : -1;
        if (priority != -1 && priority < 0 || priority > 10) {
            throw new IllegalArgumentException("priority is out of range " + priority);
        }
        ModelNode properties = operation.hasDefined("properties") ? operation.get("properties") : null;
        ModelNode model = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        model.get("name").set(name);
        if (groupName != null) {
            model.get("group-name").set(groupName);
        }
        if (threadNamePattern != null) {
            model.get("thread-name-pattern").set(threadNamePattern);
        }
        if (priority >= 0) {
            model.get("priority").set(priority);
        }
        if (properties != null) {
            model.get("properties").set(properties);
        }
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    ServiceTarget target = context.getServiceTarget();
                    ThreadFactoryService service = new ThreadFactoryService();
                    service.setNamePattern(threadNamePattern);
                    service.setPriority(priority);
                    service.setThreadGroupName(groupName);
                    target.addService(ThreadsServices.threadFactoryName(name), (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.removeService(ThreadsServices.threadFactoryName(name));
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.ADD_THREAD_FACTORY_DESC.getModelDescription(locale);
    }
}

