/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.message.DOMURIDereferencer;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignatureBase;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.DOMX509Data;
import org.apache.ws.security.message.token.DOMX509IssuerSerial;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecSignature
extends WSSecSignatureBase {
    private static Log log = LogFactory.getLog(WSSecSignature.class);
    protected boolean useSingleCert = true;
    protected String sigAlgo = null;
    protected String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected byte[] signatureValue = null;
    protected Document document = null;
    protected WSDocInfo wsDocInfo = null;
    protected String certUri = null;
    protected String keyInfoUri = null;
    protected SecurityTokenReference secRef = null;
    protected String strUri = null;
    protected BinarySecurity bstToken = null;
    protected KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM");
    protected XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
    protected KeyInfo keyInfo;
    protected CanonicalizationMethod c14nMethod;
    protected XMLSignature sig;
    protected byte[] secretKey = null;
    protected String customTokenValueType;
    protected String customTokenId;
    private String encrKeySha1value = null;
    private Crypto crypto = null;
    private String digestAlgo = "http://www.w3.org/2000/09/xmldsig#sha1";
    private X509Certificate useThisCert = null;
    private Element securityHeader = null;
    private boolean useCustomSecRef;

    public WSSecSignature() {
    }

    public WSSecSignature(WSSConfig config) {
        super(config);
    }

    public void prepare(Document doc, Crypto cr, WSSecHeader secHeader) throws WSSecurityException {
        this.crypto = cr;
        this.document = doc;
        this.wsDocInfo = new WSDocInfo(doc);
        this.wsDocInfo.setCrypto(cr);
        this.securityHeader = secHeader.getSecurityHeader();
        X509Certificate[] certs = this.getSigningCerts();
        try {
            ExcC14NParameterSpec c14nSpec = null;
            if (this.getWsConfig().isWsiBSPCompliant() && this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                List<String> prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                c14nSpec = new ExcC14NParameterSpec(prefixes);
            }
            this.c14nMethod = this.signatureFactory.newCanonicalizationMethod(this.canonAlgo, c14nSpec);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new WSSecurityException(10, "noXMLSig", null, ex);
        }
        this.keyInfoUri = this.getWsConfig().getIdAllocator().createSecureId("KI-", this.keyInfo);
        if (!this.useCustomSecRef) {
            this.secRef = new SecurityTokenReference(doc);
            this.strUri = this.getWsConfig().getIdAllocator().createSecureId("STR-", this.secRef);
            this.secRef.setID(this.strUri);
            switch (this.keyIdentifierType) {
                case 1: {
                    Reference ref = new Reference(this.document);
                    ref.setURI("#" + this.certUri);
                    if (!this.useSingleCert) {
                        this.bstToken = new PKIPathSecurity(this.document);
                        ((PKIPathSecurity)this.bstToken).setX509Certificates(certs, this.crypto);
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1");
                    } else {
                        this.bstToken = new X509Security(this.document);
                        ((X509Security)this.bstToken).setX509Certificate(certs[0]);
                    }
                    ref.setValueType(this.bstToken.getValueType());
                    this.secRef.setReference(ref);
                    this.bstToken.setID(this.certUri);
                    this.wsDocInfo.addTokenElement(this.bstToken.getElement(), false);
                    break;
                }
                case 2: {
                    String issuer = certs[0].getIssuerX500Principal().getName();
                    BigInteger serialNumber = certs[0].getSerialNumber();
                    DOMX509IssuerSerial domIssuerSerial = new DOMX509IssuerSerial(doc, issuer, serialNumber);
                    DOMX509Data domX509Data = new DOMX509Data(doc, domIssuerSerial);
                    this.secRef.setX509Data(domX509Data);
                    break;
                }
                case 3: {
                    this.secRef.setKeyIdentifier(certs[0]);
                    break;
                }
                case 4: {
                    this.secRef.setKeyIdentifierSKI(certs[0], this.crypto);
                    break;
                }
                case 8: {
                    this.secRef.setKeyIdentifierThumb(certs[0]);
                    break;
                }
                case 10: {
                    if (this.encrKeySha1value != null) {
                        this.secRef.setKeyIdentifierEncKeySHA1(this.encrKeySha1value);
                    } else {
                        byte[] digestBytes = WSSecurityUtil.generateDigest(this.secretKey);
                        this.secRef.setKeyIdentifierEncKeySHA1(Base64.encode(digestBytes));
                    }
                    this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    break;
                }
                case 9: {
                    Reference refCust = new Reference(this.document);
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                        refCust.setValueType(this.customTokenValueType);
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                        refCust.setValueType(this.customTokenValueType);
                    } else {
                        refCust.setValueType(this.customTokenValueType);
                    }
                    refCust.setURI("#" + this.customTokenId);
                    this.secRef.setReference(refCust);
                    break;
                }
                case 11: {
                    Reference refCustd = new Reference(this.document);
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                        refCustd.setValueType(this.customTokenValueType);
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                        refCustd.setValueType(this.customTokenValueType);
                    } else {
                        refCustd.setValueType(this.customTokenValueType);
                    }
                    refCustd.setURI(this.customTokenId);
                    this.secRef.setReference(refCustd);
                    break;
                }
                case 12: {
                    this.secRef.setKeyIdentifier(this.customTokenValueType, this.customTokenId);
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                        break;
                    }
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                        break;
                    }
                    if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(this.customTokenValueType)) {
                        this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                        break;
                    }
                    if (!"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(this.customTokenValueType)) break;
                    this.secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    break;
                }
                case 13: {
                    PublicKey publicKey = certs[0].getPublicKey();
                    try {
                        KeyValue keyValue = this.keyInfoFactory.newKeyValue(publicKey);
                        this.keyInfo = this.keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue), this.keyInfoUri);
                        break;
                    }
                    catch (KeyException ex) {
                        log.error((Object)"", (Throwable)ex);
                        throw new WSSecurityException(10, "noXMLSig", null, ex);
                    }
                }
                default: {
                    throw new WSSecurityException(0, "unsupportedKeyId");
                }
            }
        }
        if (this.keyIdentifierType != 13) {
            DOMStructure structure = new DOMStructure(this.secRef.getElement());
            this.wsDocInfo.addTokenElement(this.secRef.getElement(), false);
            this.keyInfo = this.keyInfoFactory.newKeyInfo(Collections.singletonList(structure), this.keyInfoUri);
        }
    }

    public Document build(Document doc, Crypto cr, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"Beginning signing...");
        }
        this.prepare(doc, cr, secHeader);
        if (this.parts == null) {
            this.parts = new ArrayList(1);
            String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
            WSEncryptionPart encP = new WSEncryptionPart("Body", soapNamespace, "Content");
            this.parts.add(encP);
        } else {
            for (WSEncryptionPart part : this.parts) {
                if (!"STRTransform".equals(part.getName()) || part.getId() != null) continue;
                part.setId(this.strUri);
            }
        }
        List<javax.xml.crypto.dsig.Reference> referenceList = this.addReferencesToSign(this.parts, secHeader);
        this.computeSignature(referenceList);
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        return doc;
    }

    public List<javax.xml.crypto.dsig.Reference> addReferencesToSign(List<WSEncryptionPart> references, WSSecHeader secHeader) throws WSSecurityException {
        return this.addReferencesToSign(this.document, references, this.wsDocInfo, this.signatureFactory, secHeader, this.getWsConfig(), this.digestAlgo);
    }

    public Element getSignatureElement() {
        return WSSecurityUtil.getDirectChildElement(this.securityHeader, "Signature", "http://www.w3.org/2000/09/xmldsig#");
    }

    public void prependBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public void appendBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            Element secHeaderElement = secHeader.getSecurityHeader();
            secHeaderElement.appendChild(this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public void computeSignature(List<javax.xml.crypto.dsig.Reference> referenceList) throws WSSecurityException {
        this.computeSignature(referenceList, true, null);
    }

    public void computeSignature(List<javax.xml.crypto.dsig.Reference> referenceList, boolean prepend, Element siblingElement) throws WSSecurityException {
        try {
            Key key = this.secretKey == null ? this.crypto.getPrivateKey(this.user, this.password) : WSSecurityUtil.prepareSecretKey(this.sigAlgo, this.secretKey);
            SignatureMethod signatureMethod = this.signatureFactory.newSignatureMethod(this.sigAlgo, null);
            SignedInfo signedInfo = this.signatureFactory.newSignedInfo(this.c14nMethod, signatureMethod, referenceList);
            this.sig = this.signatureFactory.newXMLSignature(signedInfo, this.keyInfo, null, this.getWsConfig().getIdAllocator().createId("SIG-", null), null);
            DOMSignContext signContext = null;
            if (prepend) {
                if (siblingElement == null) {
                    Node child;
                    for (child = this.securityHeader.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
                    }
                    siblingElement = (Element)child;
                }
                signContext = siblingElement == null ? new DOMSignContext(key, (Node)this.securityHeader) : new DOMSignContext(key, (Node)this.securityHeader, (Node)siblingElement);
            } else {
                signContext = new DOMSignContext(key, (Node)this.securityHeader);
            }
            signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.canonAlgo)) {
                signContext.putNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            }
            signContext.setProperty("transform_ws_doc_info", this.wsDocInfo);
            this.wsDocInfo.setCallbackLookup(this.callbackLookup);
            DOMURIDereferencer dereferencer = new DOMURIDereferencer();
            dereferencer.setWsDocInfo(this.wsDocInfo);
            signContext.setURIDereferencer(dereferencer);
            this.sig.sign(signContext);
            this.signatureValue = this.sig.getSignatureValue().getValue();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new WSSecurityException(10, null, null, ex);
        }
    }

    public void setUseSingleCertificate(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
    }

    public boolean isUseSingleCertificate() {
        return this.useSingleCert;
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigAlgo = algo;
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgo;
    }

    public void setSigCanonicalization(String algo) {
        this.canonAlgo = algo;
    }

    public String getSigCanonicalization() {
        return this.canonAlgo;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    public void setDigestAlgo(String digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public String getId() {
        if (this.sig == null) {
            return null;
        }
        return this.sig.getId();
    }

    public String getBSTTokenId() {
        if (this.bstToken == null) {
            return null;
        }
        return this.bstToken.getID();
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }

    public void setCustomTokenValueType(String customTokenValueType) {
        this.customTokenValueType = customTokenValueType;
    }

    public void setCustomTokenId(String customTokenId) {
        this.customTokenId = customTokenId;
    }

    public void setEncrKeySha1value(String encrKeySha1value) {
        this.encrKeySha1value = encrKeySha1value;
    }

    public void setX509Certificate(X509Certificate cer) {
        this.useThisCert = cer;
    }

    public Element getBinarySecurityTokenElement() {
        if (this.bstToken != null) {
            return this.bstToken.getElement();
        }
        return null;
    }

    public String getSecurityTokenReferenceURI() {
        return this.strUri;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.secRef;
    }

    public void setSecurityTokenReference(SecurityTokenReference secRef) {
        this.useCustomSecRef = true;
        this.secRef = secRef;
    }

    private X509Certificate[] getSigningCerts() throws WSSecurityException {
        X509Certificate[] certs = null;
        if (this.keyIdentifierType != 9 && this.keyIdentifierType != 11 && this.keyIdentifierType != 10 && this.keyIdentifierType != 12) {
            if (this.useThisCert == null) {
                CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                cryptoType.setAlias(this.user);
                certs = this.crypto.getX509Certificates(cryptoType);
            } else {
                certs = new X509Certificate[]{this.useThisCert};
            }
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "noUserCertsFound", new Object[]{this.user, "signature"});
            }
            this.certUri = this.getWsConfig().getIdAllocator().createSecureId("X509-", certs[0]);
            if (this.sigAlgo == null) {
                String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
                log.debug((Object)("Automatic signature algorithm detection: " + pubKeyAlgo));
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                } else {
                    throw new WSSecurityException(0, "unknownSignatureAlgorithm", new Object[]{pubKeyAlgo});
                }
            }
        }
        return certs;
    }
}

