/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.FluentGlobalConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.ChannelProvider;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.ExecutorProvider;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

@Listener
public class EmbeddedCacheManagerService
implements Service<CacheContainer> {
    private static final Logger log = Logger.getLogger((String)EmbeddedCacheManagerService.class.getPackage().getName());
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan"});
    private final EmbeddedCacheManagerConfiguration configuration;
    private volatile CacheContainer container;

    public static ServiceName getServiceName(String name) {
        return name != null ? SERVICE_NAME.append(new String[]{name}) : SERVICE_NAME;
    }

    public EmbeddedCacheManagerService(EmbeddedCacheManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public CacheContainer getValue() throws IllegalStateException, IllegalArgumentException {
        return this.container;
    }

    public void start(StartContext context) throws StartException {
        TransactionSynchronizationRegistry txSyncRegistry;
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService evictionExecutor;
        EmbeddedCacheManagerDefaults defaults = this.configuration.getDefaults();
        GlobalConfiguration global = defaults.getGlobalConfiguration().clone();
        TransportConfiguration transport = this.configuration.getTransportConfiguration();
        FluentGlobalConfiguration.TransportConfig fluentTransport = global.fluent().transport();
        if (transport != null) {
            String machine;
            String rack;
            String site;
            fluentTransport.transportClass(JGroupsTransport.class);
            Long timeout = transport.getLockTimeout();
            if (timeout != null) {
                fluentTransport.distributedSyncTimeout(Long.valueOf(timeout));
            }
            if ((site = transport.getSite()) != null) {
                fluentTransport.siteId(site);
            }
            if ((rack = transport.getRack()) != null) {
                fluentTransport.rackId(rack);
            }
            if ((machine = transport.getMachine()) != null) {
                fluentTransport.machineId(machine);
            }
            fluentTransport.nodeName(transport.getEnvironment().getNodeName());
            fluentTransport.clusterName(this.configuration.getName());
            ChannelProvider.init(global, transport.getChannelFactory());
            Executor executor = transport.getExecutor();
            if (executor != null) {
                ExecutorProvider.initTransportExecutor(global, executor);
            }
        } else {
            fluentTransport.transportClass(null);
        }
        Executor listenerExecutor = this.configuration.getListenerExecutor();
        if (listenerExecutor != null) {
            ExecutorProvider.initListenerExecutor(global, listenerExecutor);
        }
        if ((evictionExecutor = this.configuration.getEvictionExecutor()) != null) {
            ExecutorProvider.initEvictionExecutor(global, evictionExecutor);
        }
        if ((replicationQueueExecutor = this.configuration.getReplicationQueueExecutor()) != null) {
            ExecutorProvider.initReplicationQueueExecutor(global, replicationQueueExecutor);
        }
        FluentGlobalConfiguration.GlobalJmxStatisticsConfig globalJmx = fluentTransport.globalJmxStatistics();
        globalJmx.cacheManagerName(this.configuration.getName());
        Configuration defaultConfig = new Configuration();
        FluentConfiguration fluent = defaultConfig.fluent();
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            globalJmx.mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).jmxDomain(SERVICE_NAME.getCanonicalName());
            fluent.jmxStatistics();
        } else {
            globalJmx.disable();
        }
        FluentConfiguration.TransactionConfig tx = fluent.transaction();
        TransactionManager txManager = this.configuration.getTransactionManager();
        if (txManager != null) {
            tx.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(txManager));
        }
        if ((txSyncRegistry = this.configuration.getTransactionSynchronizationRegistry()) != null) {
            tx.transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(txSyncRegistry));
        }
        DefaultCacheManager manager = new DefaultCacheManager(global, defaultConfig, false);
        manager.addListener((Object)this);
        for (Map.Entry<String, Configuration> entry : this.configuration.getConfigurations().entrySet()) {
            Configuration overrides = entry.getValue();
            Configuration configuration = defaults.getDefaultConfiguration(overrides.getCacheMode()).clone();
            configuration.applyOverrides(overrides);
            manager.defineConfiguration(entry.getKey(), configuration);
        }
        this.container = new DefaultEmbeddedCacheManager((EmbeddedCacheManager)manager, this.configuration.getDefaultCache());
        this.container.start();
    }

    public void stop(StopContext context) {
        this.container.stop();
        this.container = null;
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        String cacheName = event.getCacheName();
        EmbeddedCacheManager container = event.getCacheManager();
        log.infof("Started %s cache from %s container", (Object)cacheName, (Object)container.getGlobalConfiguration().getCacheManagerName());
        XAResourceRecoveryRegistry recoveryRegistry = this.configuration.getXAResourceRecoveryRegistry();
        if (recoveryRegistry != null && container.defineConfiguration(cacheName, new Configuration()).isTransactionRecoveryEnabled()) {
            recoveryRegistry.addXAResourceRecovery((XAResourceRecovery)new InfinispanXAResourceRecovery(cacheName, container));
        }
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        String cacheName = event.getCacheName();
        EmbeddedCacheManager container = event.getCacheManager();
        log.infof("Stopped %s cache from %s container", (Object)cacheName, (Object)container.getGlobalConfiguration().getCacheManagerName());
        XAResourceRecoveryRegistry recoveryRegistry = this.configuration.getXAResourceRecoveryRegistry();
        if (recoveryRegistry != null) {
            recoveryRegistry.removeXAResourceRecovery((XAResourceRecovery)new InfinispanXAResourceRecovery(cacheName, container));
        }
    }

    static class InfinispanXAResourceRecovery
    implements XAResourceRecovery {
        private final String cacheName;
        private final EmbeddedCacheManager container;

        InfinispanXAResourceRecovery(String cacheName, EmbeddedCacheManager container) {
            this.cacheName = cacheName;
            this.container = container;
        }

        public XAResource[] getXAResources() {
            return new XAResource[]{this.container.getCache(this.cacheName).getAdvancedCache().getXAResource()};
        }

        public int hashCode() {
            return this.container.getGlobalConfiguration().getCacheManagerName().hashCode() ^ this.cacheName.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InfinispanXAResourceRecovery)) {
                return false;
            }
            InfinispanXAResourceRecovery recovery = (InfinispanXAResourceRecovery)object;
            return this.container.getGlobalConfiguration().getCacheManagerName().equals(recovery.container.getGlobalConfiguration().getCacheManagerName()) && this.cacheName.equals(recovery.cacheName);
        }

        public String toString() {
            return this.container.getGlobalConfiguration().getCacheManagerName() + "." + this.cacheName;
        }
    }
}

