/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.ModuleLoaderProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;

final class DefaultModuleLoaderIntegration
extends ModuleLoader
implements ModuleLoaderProvider {
    static final Logger log = Logger.getLogger(DefaultModuleLoaderIntegration.class);
    private Map<ModuleIdentifier, ModuleHolder> moduleSpecs = new ConcurrentHashMap<ModuleIdentifier, ModuleHolder>();

    static void addService(ServiceTarget serviceTarget) {
        DefaultModuleLoaderIntegration service = new DefaultModuleLoaderIntegration();
        ServiceBuilder builder = serviceTarget.addService(Services.MODULE_LOADER_PROVIDER, (Service)service);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private DefaultModuleLoaderIntegration() {
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting: %s", (Object)context.getController().getName());
    }

    public void stop(StopContext context) {
        log.debugf("Stopping: %s", (Object)context.getController().getName());
    }

    public ModuleLoaderProvider getValue() {
        return this;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this;
    }

    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
        return moduleHolder != null ? moduleHolder.getModuleSpec() : null;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = null;
        ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
        if (moduleHolder != null && (module = moduleHolder.getModule()) == null) {
            module = this.loadModuleLocal(identifier);
            moduleHolder.setModule(module);
        }
        return module;
    }

    @Override
    public void addModule(ModuleSpec moduleSpec) {
        log.tracef("addModule: %s", (Object)moduleSpec.getModuleIdentifier());
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        if (this.moduleSpecs.get(identifier) != null) {
            throw new IllegalStateException("Module already exists: " + identifier);
        }
        ModuleHolder moduleHolder = new ModuleHolder(moduleSpec);
        this.moduleSpecs.put(identifier, moduleHolder);
    }

    @Override
    public void addModule(Module module) {
        log.tracef("addModule: %s", (Object)module.getIdentifier());
        ModuleIdentifier identifier = module.getIdentifier();
        if (this.moduleSpecs.get(identifier) != null) {
            throw new IllegalStateException("Module already exists: " + identifier);
        }
        ModuleHolder moduleHolder = new ModuleHolder(module);
        this.moduleSpecs.put(identifier, moduleHolder);
    }

    @Override
    public void removeModule(ModuleIdentifier identifier) {
        log.tracef("removeModule: %s", (Object)identifier);
        this.moduleSpecs.remove(identifier);
        try {
            Module module = this.loadModuleLocal(identifier);
            if (module != null) {
                this.unloadModuleLocal(module);
            }
        }
        catch (ModuleLoadException moduleLoadException) {
            // empty catch block
        }
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XModule resModule) {
        XModuleIdentity moduleId = resModule.getModuleId();
        String slot = moduleId.getVersion().toString();
        int revision = moduleId.getRevision();
        if (revision > 0) {
            slot = slot + "-rev" + revision;
        }
        String name = "jbosgi." + moduleId.getName();
        return ModuleIdentifier.create((String)name, (String)slot);
    }

    @Override
    public void setAndRelinkDependencies(Module module, List<DependencySpec> dependencies) throws ModuleLoadException {
        super.setAndRelinkDependencies(module, dependencies);
    }

    public String toString() {
        return DefaultModuleLoaderIntegration.class.getSimpleName();
    }

    static class ModuleHolder {
        private ModuleSpec moduleSpec;
        private Module module;

        ModuleHolder(ModuleSpec moduleSpec) {
            if (moduleSpec == null) {
                throw new IllegalArgumentException("Null moduleSpec");
            }
            this.moduleSpec = moduleSpec;
        }

        ModuleHolder(Module module) {
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            this.module = module;
        }

        ModuleSpec getModuleSpec() {
            return this.moduleSpec;
        }

        Module getModule() {
            return this.module;
        }

        void setModule(Module module) {
            this.module = module;
        }
    }
}

