/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.LockingInterceptor;

public class DistLockingInterceptor
extends LockingInterceptor {
    DistributionManager dm;

    @Inject
    public void injectDistributionManager(DistributionManager dm) {
        this.dm = dm;
    }

    @Override
    protected void commitEntry(CacheEntry entry, boolean skipOwnershipCheck) {
        boolean doCommit = true;
        if (!(skipOwnershipCheck || entry.isRemoved() || this.dm.getLocality(entry.getKey()).isLocal())) {
            if (this.configuration.isL1CacheEnabled()) {
                this.dm.transformForL1(entry);
            } else {
                doCommit = false;
            }
        }
        if (doCommit) {
            entry.commit(this.dataContainer);
        } else {
            entry.rollback();
        }
    }
}

