/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import javax.persistence.GenerationType;
import org.hibernate.AssertionFailure;
import org.hibernate.id.MultipleHiLoPerTableGenerator;

public class TypeEnumConversionHelper {
    private TypeEnumConversionHelper() {
    }

    public static String generationTypeToGeneratorStrategyName(GenerationType generatorEnum, boolean useNewGeneratorMappings) {
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return useNewGeneratorMappings ? "enhanced-sequence" : "native";
            }
            case TABLE: {
                return useNewGeneratorMappings ? "enhanced-table" : MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return useNewGeneratorMappings ? "enhanced-sequence" : "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }
}

