/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.DiscriminatorType;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.ColumnValues;
import org.hibernate.metamodel.source.annotations.attribute.FormulaValue;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClassType;
import org.hibernate.metamodel.source.annotations.entity.IdType;
import org.hibernate.metamodel.source.annotations.entity.TableSourceImpl;
import org.hibernate.metamodel.source.annotations.entity.UniqueConstraintSourceImpl;
import org.hibernate.metamodel.source.binder.ConstraintSource;
import org.hibernate.metamodel.source.binder.TableSource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class EntityClass
extends ConfiguredClass {
    private final IdType idType;
    private final InheritanceType inheritanceType;
    private final String explicitEntityName;
    private final String customLoaderQueryName;
    private final List<String> synchronizedTableNames;
    private final int batchSize;
    private final TableSource primaryTableSource;
    private final Set<TableSource> secondaryTableSources;
    private final Set<ConstraintSource> constraintSources;
    private boolean isMutable;
    private boolean isExplicitPolymorphism;
    private OptimisticLockStyle optimisticLockStyle;
    private String whereClause;
    private String rowId;
    private Caching caching;
    private boolean isDynamicInsert;
    private boolean isDynamicUpdate;
    private boolean isSelectBeforeUpdate;
    private String customPersister;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private boolean isLazy;
    private String proxy;
    private ColumnValues discriminatorColumnValues;
    private FormulaValue discriminatorFormula;
    private Class<?> discriminatorType;
    private String discriminatorMatchValue;
    private boolean isDiscriminatorForced = true;
    private boolean isDiscriminatorIncludedInSql = true;

    public EntityClass(ClassInfo classInfo, EntityClass parent, AccessType hierarchyAccessType, InheritanceType inheritanceType, AnnotationBindingContext context) {
        super(classInfo, hierarchyAccessType, parent, context);
        this.inheritanceType = inheritanceType;
        this.idType = this.determineIdType();
        boolean hasOwnTable = this.definesItsOwnTable();
        this.explicitEntityName = this.determineExplicitEntityName();
        this.constraintSources = new HashSet<ConstraintSource>();
        this.primaryTableSource = hasOwnTable ? this.createTableSource(JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.TABLE)) : null;
        this.secondaryTableSources = this.createSecondaryTableSources();
        this.customLoaderQueryName = this.determineCustomLoader();
        this.synchronizedTableNames = this.determineSynchronizedTableNames();
        this.batchSize = this.determineBatchSize();
        this.processHibernateEntitySpecificAnnotations();
        this.processCustomSqlAnnotations();
        this.processProxyGeneration();
        this.processDiscriminator();
    }

    public ColumnValues getDiscriminatorColumnValues() {
        return this.discriminatorColumnValues;
    }

    public FormulaValue getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    public Class<?> getDiscriminatorType() {
        return this.discriminatorType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public boolean isExplicitPolymorphism() {
        return this.isExplicitPolymorphism;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public String getRowId() {
        return this.rowId;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public TableSource getPrimaryTableSource() {
        if (this.definesItsOwnTable()) {
            return this.primaryTableSource;
        }
        return ((EntityClass)this.getParent()).getPrimaryTableSource();
    }

    public Set<TableSource> getSecondaryTableSources() {
        return this.secondaryTableSources;
    }

    public Set<ConstraintSource> getConstraintSources() {
        return this.constraintSources;
    }

    public String getExplicitEntityName() {
        return this.explicitEntityName;
    }

    public String getEntityName() {
        return this.getConfiguredClass().getSimpleName();
    }

    public boolean isDynamicInsert() {
        return this.isDynamicInsert;
    }

    public boolean isDynamicUpdate() {
        return this.isDynamicUpdate;
    }

    public boolean isSelectBeforeUpdate() {
        return this.isSelectBeforeUpdate;
    }

    public String getCustomLoaderQueryName() {
        return this.customLoaderQueryName;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }

    public List<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }

    public String getCustomPersister() {
        return this.customPersister;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public String getProxy() {
        return this.proxy;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isEntityRoot() {
        return this.getParent() == null;
    }

    public boolean isDiscriminatorForced() {
        return this.isDiscriminatorForced;
    }

    public boolean isDiscriminatorIncludedInSql() {
        return this.isDiscriminatorIncludedInSql;
    }

    private String determineExplicitEntityName() {
        AnnotationInstance jpaEntityAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.ENTITY);
        return JandexHelper.getValue(jpaEntityAnnotation, "name", String.class);
    }

    private boolean definesItsOwnTable() {
        return !InheritanceType.SINGLE_TABLE.equals((Object)this.inheritanceType) || this.isEntityRoot();
    }

    private IdType determineIdType() {
        List<AnnotationInstance> idAnnotations = this.findIdAnnotations(JPADotNames.ID);
        List<AnnotationInstance> embeddedIdAnnotations = this.findIdAnnotations(JPADotNames.EMBEDDED_ID);
        if (!idAnnotations.isEmpty() && !embeddedIdAnnotations.isEmpty()) {
            throw new MappingException("@EmbeddedId and @Id cannot be used together. Check the configuration for " + this.getName() + ".");
        }
        if (!embeddedIdAnnotations.isEmpty()) {
            if (embeddedIdAnnotations.size() == 1) {
                return IdType.EMBEDDED;
            }
            throw new AnnotationException("Multiple @EmbeddedId annotations are not allowed");
        }
        if (!idAnnotations.isEmpty()) {
            if (idAnnotations.size() == 1) {
                return IdType.SIMPLE;
            }
            return IdType.COMPOSED;
        }
        return IdType.NONE;
    }

    private List<AnnotationInstance> findIdAnnotations(DotName idAnnotationType) {
        ArrayList<AnnotationInstance> idAnnotationList = new ArrayList<AnnotationInstance>();
        if (this.getClassInfo().annotations().get(idAnnotationType) != null) {
            idAnnotationList.addAll((Collection)this.getClassInfo().annotations().get(idAnnotationType));
        }
        for (ConfiguredClass parent = this.getParent(); parent != null && (ConfiguredClassType.MAPPED_SUPERCLASS.equals((Object)parent.getConfiguredClassType()) || ConfiguredClassType.NON_ENTITY.equals((Object)parent.getConfiguredClassType())); parent = parent.getParent()) {
            if (parent.getClassInfo().annotations().get(idAnnotationType) == null) continue;
            idAnnotationList.addAll((Collection)parent.getClassInfo().annotations().get(idAnnotationType));
        }
        return idAnnotationList;
    }

    private void processDiscriminator() {
        if (!InheritanceType.SINGLE_TABLE.equals((Object)this.inheritanceType)) {
            return;
        }
        AnnotationInstance discriminatorValueAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.DISCRIMINATOR_VALUE);
        if (discriminatorValueAnnotation != null) {
            this.discriminatorMatchValue = discriminatorValueAnnotation.value().asString();
        }
        AnnotationInstance discriminatorColumnAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.DISCRIMINATOR_COLUMN);
        AnnotationInstance discriminatorFormulaAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.DISCRIMINATOR_FORMULA);
        Class type = String.class;
        if (discriminatorFormulaAnnotation != null) {
            String expression = JandexHelper.getValue(discriminatorFormulaAnnotation, "value", String.class);
            this.discriminatorFormula = new FormulaValue(this.getPrimaryTableSource().getExplicitTableName(), expression);
        }
        this.discriminatorColumnValues = new ColumnValues(null);
        this.discriminatorColumnValues.setNullable(false);
        if (discriminatorColumnAnnotation != null) {
            DiscriminatorType discriminatorType = Enum.valueOf(DiscriminatorType.class, discriminatorColumnAnnotation.value("discriminatorType").asEnum());
            switch (discriminatorType) {
                case STRING: {
                    type = String.class;
                    break;
                }
                case CHAR: {
                    type = Character.class;
                    break;
                }
                case INTEGER: {
                    type = Integer.class;
                    break;
                }
                default: {
                    throw new AnnotationException("Unsupported discriminator type: " + discriminatorType);
                }
            }
            this.discriminatorColumnValues.setName(JandexHelper.getValue(discriminatorColumnAnnotation, "name", String.class));
            this.discriminatorColumnValues.setLength(JandexHelper.getValue(discriminatorColumnAnnotation, "length", Integer.class));
            this.discriminatorColumnValues.setColumnDefinition(JandexHelper.getValue(discriminatorColumnAnnotation, "columnDefinition", String.class));
        }
        this.discriminatorType = type;
        AnnotationInstance discriminatorOptionsAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.DISCRIMINATOR_OPTIONS);
        if (discriminatorOptionsAnnotation != null) {
            this.isDiscriminatorForced = discriminatorOptionsAnnotation.value("force").asBoolean();
            this.isDiscriminatorIncludedInSql = discriminatorOptionsAnnotation.value("insert").asBoolean();
        } else {
            this.isDiscriminatorForced = false;
            this.isDiscriminatorIncludedInSql = true;
        }
    }

    private void processHibernateEntitySpecificAnnotations() {
        String entityPersisterClass;
        AnnotationInstance hibernateEntityAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.ENTITY);
        PolymorphismType polymorphism = PolymorphismType.IMPLICIT;
        if (hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("polymorphism") != null) {
            polymorphism = PolymorphismType.valueOf(hibernateEntityAnnotation.value("polymorphism").asEnum());
        }
        this.isExplicitPolymorphism = polymorphism == PolymorphismType.EXPLICIT;
        OptimisticLockType optimisticLockType = OptimisticLockType.VERSION;
        if (hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("optimisticLock") != null) {
            optimisticLockType = OptimisticLockType.valueOf(hibernateEntityAnnotation.value("optimisticLock").asEnum());
        }
        this.optimisticLockStyle = OptimisticLockStyle.valueOf(optimisticLockType.name());
        AnnotationInstance hibernateImmutableAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.IMMUTABLE);
        this.isMutable = hibernateImmutableAnnotation == null && hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("mutable") != null && hibernateEntityAnnotation.value("mutable").asBoolean();
        AnnotationInstance whereAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.WHERE);
        this.whereClause = whereAnnotation != null && whereAnnotation.value("clause") != null ? whereAnnotation.value("clause").asString() : null;
        AnnotationInstance rowIdAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.ROW_ID);
        this.rowId = rowIdAnnotation != null && rowIdAnnotation.value() != null ? rowIdAnnotation.value().asString() : null;
        this.caching = this.determineCachingSettings();
        this.isDynamicInsert = hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("dynamicInsert") != null && hibernateEntityAnnotation.value("dynamicInsert").asBoolean();
        this.isDynamicUpdate = hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("dynamicUpdate") != null && hibernateEntityAnnotation.value("dynamicUpdate").asBoolean();
        this.isSelectBeforeUpdate = hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("selectBeforeUpdate") != null && hibernateEntityAnnotation.value("selectBeforeUpdate").asBoolean();
        AnnotationInstance persisterAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.PERSISTER);
        if (persisterAnnotation == null || persisterAnnotation.value("impl") == null) {
            entityPersisterClass = hibernateEntityAnnotation != null && hibernateEntityAnnotation.value("persister") != null ? hibernateEntityAnnotation.value("persister").asString() : null;
        } else {
            if (hibernateEntityAnnotation == null || hibernateEntityAnnotation.value("persister") != null) {
                // empty if block
            }
            entityPersisterClass = persisterAnnotation.value("impl").asString();
        }
        this.customPersister = entityPersisterClass;
    }

    private Caching determineCachingSettings() {
        boolean doCaching;
        AnnotationInstance hibernateCacheAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.CACHE);
        if (hibernateCacheAnnotation != null) {
            org.hibernate.cache.spi.access.AccessType accessType = hibernateCacheAnnotation.value("usage") == null ? this.getLocalBindingContext().getMappingDefaults().getCacheAccessType() : CacheConcurrencyStrategy.parse(hibernateCacheAnnotation.value("usage").asEnum()).toAccessType();
            return new Caching(hibernateCacheAnnotation.value("region") == null ? this.getName() : hibernateCacheAnnotation.value("region").asString(), accessType, hibernateCacheAnnotation.value("include") != null && "all".equals(hibernateCacheAnnotation.value("include").asString()));
        }
        AnnotationInstance jpaCacheableAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.CACHEABLE);
        boolean cacheable = true;
        if (jpaCacheableAnnotation != null && jpaCacheableAnnotation.value() != null) {
            cacheable = jpaCacheableAnnotation.value().asBoolean();
        }
        switch (this.getLocalBindingContext().getMetadataImplementor().getOptions().getSharedCacheMode()) {
            case ALL: {
                doCaching = true;
                break;
            }
            case ENABLE_SELECTIVE: {
                doCaching = cacheable;
                break;
            }
            case DISABLE_SELECTIVE: {
                doCaching = jpaCacheableAnnotation == null || cacheable;
                break;
            }
            default: {
                doCaching = false;
            }
        }
        if (!doCaching) {
            return null;
        }
        return new Caching(this.getName(), this.getLocalBindingContext().getMappingDefaults().getCacheAccessType(), true);
    }

    private TableSource createTableSource(AnnotationInstance tableAnnotation) {
        String schema = null;
        String catalog = null;
        if (tableAnnotation != null) {
            schema = JandexHelper.getValue(tableAnnotation, "schema", String.class);
            catalog = JandexHelper.getValue(tableAnnotation, "catalog", String.class);
        }
        String tableName = null;
        String logicalTableName = null;
        if (tableAnnotation != null) {
            logicalTableName = JandexHelper.getValue(tableAnnotation, "name", String.class);
            if (StringHelper.isNotEmpty(logicalTableName)) {
                tableName = logicalTableName;
            }
            this.createUniqueConstraints(tableAnnotation, tableName);
        }
        TableSourceImpl tableSourceImpl = tableAnnotation == null || JPADotNames.TABLE.equals((Object)tableAnnotation.name()) ? new TableSourceImpl(schema, catalog, tableName, null) : new TableSourceImpl(schema, catalog, tableName, logicalTableName);
        return tableSourceImpl;
    }

    private Set<TableSource> createSecondaryTableSources() {
        HashSet<TableSource> secondaryTableSources = new HashSet<TableSource>();
        AnnotationInstance secondaryTables = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.SECONDARY_TABLES);
        AnnotationInstance secondaryTable = JandexHelper.getSingleAnnotation(this.getClassInfo(), JPADotNames.SECONDARY_TABLE);
        ArrayList<Object> secondaryTableAnnotations = new ArrayList<Object>();
        if (secondaryTable != null) {
            secondaryTableAnnotations.add(secondaryTable);
        }
        if (secondaryTables != null) {
            secondaryTableAnnotations.addAll(Arrays.asList((Object[])JandexHelper.getValue(secondaryTables, "value", AnnotationInstance[].class)));
        }
        for (AnnotationInstance annotationInstance : secondaryTableAnnotations) {
            secondaryTableSources.add(this.createTableSource(annotationInstance));
        }
        return secondaryTableSources;
    }

    private void createUniqueConstraints(AnnotationInstance tableAnnotation, String tableName) {
        AnnotationInstance[] uniqueConstraints;
        AnnotationValue value = tableAnnotation.value("uniqueConstraints");
        if (value == null) {
            return;
        }
        for (AnnotationInstance unique : uniqueConstraints = value.asNestedArray()) {
            String name = unique.value("name").asString();
            String[] columnNames = unique.value("columnNames").asStringArray();
            UniqueConstraintSourceImpl uniqueConstraintSource = new UniqueConstraintSourceImpl(name, tableName, Arrays.asList(columnNames));
            this.constraintSources.add(uniqueConstraintSource);
        }
    }

    private String determineCustomLoader() {
        String customLoader = null;
        AnnotationInstance sqlLoaderAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.LOADER);
        if (sqlLoaderAnnotation != null) {
            customLoader = sqlLoaderAnnotation.value("namedQuery").asString();
        }
        return customLoader;
    }

    private CustomSQL createCustomSQL(AnnotationInstance customSqlAnnotation) {
        boolean isCallable;
        if (customSqlAnnotation == null) {
            return null;
        }
        String sql = customSqlAnnotation.value("sql").asString();
        boolean bl = isCallable = customSqlAnnotation.value("callable") != null && customSqlAnnotation.value("callable").asBoolean();
        ExecuteUpdateResultCheckStyle checkStyle = customSqlAnnotation.value("check") == null ? (isCallable ? ExecuteUpdateResultCheckStyle.NONE : ExecuteUpdateResultCheckStyle.COUNT) : ExecuteUpdateResultCheckStyle.valueOf(customSqlAnnotation.value("check").asEnum());
        return new CustomSQL(sql, isCallable, checkStyle);
    }

    private void processCustomSqlAnnotations() {
        AnnotationInstance sqlInsertAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SQL_INSERT);
        this.customInsert = this.createCustomSQL(sqlInsertAnnotation);
        AnnotationInstance sqlUpdateAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SQL_UPDATE);
        this.customUpdate = this.createCustomSQL(sqlUpdateAnnotation);
        AnnotationInstance sqlDeleteAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SQL_DELETE);
        this.customDelete = this.createCustomSQL(sqlDeleteAnnotation);
    }

    private List<String> determineSynchronizedTableNames() {
        AnnotationInstance synchronizeAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.SYNCHRONIZE);
        if (synchronizeAnnotation != null) {
            String[] tableNames = synchronizeAnnotation.value().asStringArray();
            return Arrays.asList(tableNames);
        }
        return Collections.emptyList();
    }

    private void processProxyGeneration() {
        AnnotationInstance hibernateProxyAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.PROXY);
        if (hibernateProxyAnnotation != null) {
            AnnotationValue proxyClassValue;
            boolean bl = this.isLazy = hibernateProxyAnnotation.value("lazy") == null || hibernateProxyAnnotation.value("lazy").asBoolean();
            this.proxy = this.isLazy ? ((proxyClassValue = hibernateProxyAnnotation.value("proxyClass")) == null ? this.getName() : proxyClassValue.asString()) : null;
        } else {
            this.isLazy = true;
            this.proxy = this.getName();
        }
    }

    private int determineBatchSize() {
        AnnotationInstance batchSizeAnnotation = JandexHelper.getSingleAnnotation(this.getClassInfo(), HibernateDotNames.BATCH_SIZE);
        return batchSizeAnnotation == null ? -1 : batchSizeAnnotation.value("size").asInt();
    }

    public String getDiscriminatorMatchValue() {
        return this.discriminatorMatchValue;
    }
}

