/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.metamodel.source.annotation.jaxb.XMLAccessType;
import org.hibernate.metamodel.source.annotation.jaxb.XMLManyToOne;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.PropertyMocker;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class ManyToOneMocker
extends PropertyMocker {
    private XMLManyToOne manyToOne;

    ManyToOneMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default defaults, XMLManyToOne manyToOne) {
        super(indexBuilder, classInfo, defaults);
        this.manyToOne = manyToOne;
    }

    @Override
    protected String getFieldName() {
        return this.manyToOne.getName();
    }

    @Override
    protected void processExtra() {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.classValue("targetEntity", this.manyToOne.getTargetEntity(), annotationValueList, this.indexBuilder.getServiceRegistry());
        MockHelper.enumValue("fetch", FETCH_TYPE, this.manyToOne.getFetch(), annotationValueList);
        MockHelper.booleanValue("optional", this.manyToOne.isOptional(), annotationValueList);
        MockHelper.cascadeValue("cascade", this.manyToOne.getCascade(), this.isDefaultCascadePersist(), annotationValueList);
        this.create(MANY_TO_ONE, annotationValueList);
        this.parserJoinColumnList(this.manyToOne.getJoinColumn(), this.getTarget());
        this.parserJoinTable(this.manyToOne.getJoinTable(), this.getTarget());
        if (this.manyToOne.getMapsId() != null) {
            this.create(MAPS_ID, MockHelper.stringValueArray("value", this.manyToOne.getMapsId()));
        }
        if (this.manyToOne.isId() != null && this.manyToOne.isId().booleanValue()) {
            this.create(ID);
        }
    }

    @Override
    protected XMLAccessType getAccessType() {
        return this.manyToOne.getAccess();
    }

    @Override
    protected void setAccessType(XMLAccessType accessType) {
        this.manyToOne.setAccess(accessType);
    }
}

