/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.WebXmlParser;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.util.Path;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebXmlObserver
implements BundleObserver<URL> {
    private static final Log LOG = LogFactory.getLog(WebXmlObserver.class);
    private final WebXmlParser m_parser;
    private final WebAppPublisher m_publisher;
    private final Map<URI, WebApp> m_publishedWebApps;
    private final Map<String, Map<URI, WebApp>> waitingWebApps;
    private final BundleContext bundleContext;
    private final WebEventDispatcher eventDispatcher;

    WebXmlObserver(WebXmlParser parser, WebAppPublisher publisher, WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
        NullArgumentException.validateNotNull((Object)parser, (String)"Web.xml Parser");
        NullArgumentException.validateNotNull((Object)publisher, (String)"Web App Publisher");
        NullArgumentException.validateNotNull((Object)eventDispatcher, (String)"WebEvent Dispatcher");
        NullArgumentException.validateNotNull((Object)bundleContext, (String)"BundleContext");
        this.m_parser = parser;
        this.m_publisher = publisher;
        this.m_publishedWebApps = new HashMap<URI, WebApp>();
        this.waitingWebApps = new HashMap<String, Map<URI, WebApp>>();
        this.bundleContext = bundleContext;
        this.eventDispatcher = eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addingEntries(Bundle bundle, List<URL> entries) {
        NullArgumentException.validateNotNull((Object)bundle, (String)"Bundle");
        NullArgumentException.validateNotNull(entries, (String)"List of web.xml's");
        String contextName = this.extractContextName(bundle);
        LOG.info((Object)String.format("Using [%s] as web application context name", contextName));
        try {
            PreConditionException.validateEqualTo((long)entries.size(), (long)1L, (String)"Number of xml's");
            PreConditionException.validateEqualTo((long)"WEB-INF".compareToIgnoreCase(Path.getDirectParent((URL)entries.get(0))), (long)0L, (String)"Direct parent of web.xml");
        }
        catch (PreConditionException pce) {
            this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), (Throwable)pce));
            throw pce;
        }
        URL webXmlURL = entries.get(0);
        LOG.debug((Object)("Parsing a web application from [" + webXmlURL + "]"));
        String rootPath = this.extractRootPath(bundle);
        LOG.info((Object)String.format("Using [%s] as web application root path", rootPath));
        this.eventDispatcher.webEvent(new WebEvent(1, "/" + contextName, bundle, this.bundleContext.getBundle()));
        InputStream is = null;
        try {
            is = webXmlURL.openStream();
            WebApp webApp = this.m_parser.parse(is);
            if (webApp != null) {
                LOG.debug((Object)("Parsed web app [" + webApp + "]"));
                webApp.setBundle(bundle);
                webApp.setContextName(contextName);
                webApp.setRootPath(rootPath);
                WebApp alreadyPublished = this.checkAlreadyPublishedContext(contextName);
                if (alreadyPublished == null) {
                    this.doPublish(webXmlURL.toURI(), webApp);
                    this.eventDispatcher.webEvent(new WebEvent(2, "/" + contextName, bundle, this.bundleContext.getBundle()));
                } else {
                    Map<Object, Object> webAppsQueue;
                    if (this.waitingWebApps.containsKey(contextName)) {
                        webAppsQueue = this.waitingWebApps.get(contextName);
                    } else {
                        webAppsQueue = new HashMap();
                        this.waitingWebApps.put(contextName, webAppsQueue);
                    }
                    Collection<Object> webApps = webAppsQueue.values();
                    ArrayList<Long> duplicateIds = new ArrayList<Long>();
                    for (WebApp webApp2 : webApps) {
                        duplicateIds.add(webApp2.getBundle().getBundleId());
                    }
                    duplicateIds.add(alreadyPublished.getBundle().getBundleId());
                    duplicateIds.add(bundle.getBundleId());
                    webAppsQueue.put(webXmlURL.toURI(), webApp);
                    this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), duplicateIds));
                }
            }
        }
        catch (IOException ignore) {
            LOG.error((Object)"Could not parse web.xml", (Throwable)ignore);
            this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), (Throwable)ignore));
        }
        catch (URISyntaxException ignore) {
            LOG.error((Object)"Couldn't transform URL to URI ", (Throwable)ignore);
            this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), (Throwable)ignore));
        }
        catch (Exception ignore) {
            LOG.error((Object)"Could not parse web.xml", (Throwable)ignore);
            this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), (Throwable)ignore));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private String extractRootPath(Bundle bundle) {
        String rootPath = (String)bundle.getHeaders().get("Webapp-Root");
        if (rootPath == null) {
            LOG.debug((Object)"No 'Webapp-Root' manifest attribute specified");
            rootPath = "";
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        rootPath = rootPath.trim();
        return rootPath;
    }

    private String extractContextName(Bundle bundle) {
        String contextName = (String)bundle.getHeaders().get("Web-ContextPath");
        if (contextName == null) {
            contextName = (String)bundle.getHeaders().get("Webapp-Context");
        }
        if (contextName == null) {
            Bundle[] bundles;
            LOG.debug((Object)"No 'Web-ContextPath' or 'Webapp-Context' manifest attribute specified");
            for (Bundle bndl : bundles = bundle.getBundleContext().getBundles()) {
                String fragHost;
                Dictionary headers;
                if (bndl.getState() != 4 || (headers = bndl.getHeaders()).get("Fragment-Host") == null || !(fragHost = (String)headers.get("Fragment-Host")).equalsIgnoreCase(bundle.getSymbolicName())) continue;
                contextName = (String)bndl.getHeaders().get("Web-ContextPath");
                if (contextName == null) {
                    contextName = (String)bndl.getHeaders().get("Webapp-Context");
                }
                if (contextName != null) break;
            }
            if (contextName == null) {
                String symbolicName = bundle.getSymbolicName();
                if (symbolicName == null) {
                    contextName = String.valueOf(bundle.getBundleId());
                    LOG.debug((Object)String.format("Using bundle id [%s] as context name", contextName));
                } else {
                    contextName = symbolicName;
                    LOG.debug((Object)String.format("Using bundle symbolic name [%s] as context name", contextName));
                }
            }
        }
        if ((contextName = contextName.trim()).startsWith("/")) {
            contextName = contextName.substring(1);
        }
        return contextName;
    }

    private void doPublish(URI webXmlURI, WebApp webApp) throws URISyntaxException {
        this.m_publisher.publish(webApp);
        this.m_publishedWebApps.put(webXmlURI, webApp);
    }

    private WebApp checkAlreadyPublishedContext(String contextName) {
        Collection<WebApp> values = this.m_publishedWebApps.values();
        for (WebApp webApp : values) {
            WebAppInitParam[] webAppInitParams;
            for (WebAppInitParam webAppInitParam : webAppInitParams = webApp.getContextParams()) {
                if (!webAppInitParam.getParamName().equalsIgnoreCase("webapp.context") || !webAppInitParam.getParamValue().equalsIgnoreCase(contextName)) continue;
                return webApp;
            }
        }
        return null;
    }

    public void removingEntries(Bundle bundle, List<URL> entries) {
        NullArgumentException.validateNotNull((Object)bundle, (String)"Bundle");
        NullArgumentException.validateNotNull(entries, (String)"List of web.xml's");
        PreConditionException.validateEqualTo((long)1L, (long)entries.size(), (String)"Number of xml's");
        URL webXmlURL = entries.get(0);
        LOG.debug((Object)("Unregistering web application parsed from [" + webXmlURL + "]"));
        WebApp toUnpublish = null;
        try {
            toUnpublish = this.m_publishedWebApps.remove(webXmlURL.toURI());
            if (toUnpublish != null) {
                WebAppInitParam[] webAppInitParams;
                this.eventDispatcher.webEvent(new WebEvent(3, "/" + this.extractContextName(bundle), bundle, this.bundleContext.getBundle()));
                this.m_publisher.unpublish(toUnpublish);
                this.eventDispatcher.webEvent(new WebEvent(4, "/" + this.extractContextName(bundle), bundle, this.bundleContext.getBundle()));
                LOG.debug((Object)"Check for a waiting webapp.");
                String unPublishedContext = null;
                for (WebAppInitParam webAppInitParam : webAppInitParams = toUnpublish.getContextParams()) {
                    if (!webAppInitParam.getParamName().equalsIgnoreCase("webapp.context")) continue;
                    unPublishedContext = webAppInitParam.getParamValue();
                    break;
                }
                if (this.waitingWebApps.containsKey(unPublishedContext)) {
                    LOG.debug((Object)"Found another bundle waiting for the context");
                    Map<URI, WebApp> waitingQueue = this.waitingWebApps.get(unPublishedContext);
                    Set<URI> keySet = waitingQueue.keySet();
                    if (!keySet.isEmpty()) {
                        URI webXmlURI = keySet.iterator().next();
                        WebApp webApp = waitingQueue.remove(webXmlURI);
                        LOG.debug((Object)"Registering the waiting bundle for the webapp.context");
                        this.eventDispatcher.webEvent(new WebEvent(1, "/" + unPublishedContext, webApp.getBundle(), this.bundleContext.getBundle()));
                        this.doPublish(webXmlURI, webApp);
                        this.eventDispatcher.webEvent(new WebEvent(2, "/" + unPublishedContext, webApp.getBundle(), this.bundleContext.getBundle()));
                    }
                }
            } else if (!this.waitingWebApps.isEmpty()) {
                Set<String> keySet = this.waitingWebApps.keySet();
                String removeKey = null;
                for (String key : keySet) {
                    Map<URI, WebApp> waitingQueue = this.waitingWebApps.get(key);
                    if (!waitingQueue.containsKey(webXmlURL.toURI())) continue;
                    waitingQueue.remove(webXmlURL.toURI());
                    if (!waitingQueue.isEmpty()) break;
                    removeKey = key;
                    break;
                }
                if (removeKey != null) {
                    this.waitingWebApps.remove(removeKey);
                }
                this.eventDispatcher.webEvent(new WebEvent(4, "/" + this.extractContextName(bundle), bundle, this.bundleContext.getBundle()));
            }
        }
        catch (URISyntaxException ignore) {
            LOG.error((Object)String.format("Removing webapp with URL: [%s] failed ", webXmlURL), (Throwable)ignore);
        }
    }
}

