/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.ejb.TimerHandle;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.timer.schedule.CalendarBasedTimeout;
import org.jboss.ejb3.timerservice.api.Timer;
import org.jboss.ejb3.timerservice.api.TimerService;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.TimerHandleImpl;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.ejb3.timerservice.mk2.persistence.CalendarTimerEntity;
import org.jboss.ejb3.timerservice.mk2.persistence.TimeoutMethod;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerPersistence;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.ejb3.timerservice.spi.ScheduleTimer;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.logging.Logger;

public class TimerServiceImpl
implements TimerService {
    private static Logger logger = Logger.getLogger(TimerServiceImpl.class);
    private final TimedObjectInvoker invoker;
    private final TimerPersistence timerPersistence;
    private final TransactionManager transactionManager;
    private final ExecutorService executorService;
    private final java.util.Timer timer;
    private final Map<TimerHandle, TimerImpl> nonPersistentTimers = new ConcurrentHashMap<TimerHandle, TimerImpl>();
    private final Map<TimerHandle, TimerImpl> persistentWaitingOnTxCompletionTimers = new ConcurrentHashMap<TimerHandle, TimerImpl>();
    private final Map<TimerHandle, java.util.TimerTask> scheduledTimerFutures = new ConcurrentHashMap<TimerHandle, java.util.TimerTask>();

    public TimerServiceImpl(java.util.Timer timer, TimedObjectInvoker invoker, TimerPersistence timerPersistence, TransactionManager transactionManager, ExecutorService executor) {
        if (invoker == null) {
            throw new IllegalArgumentException("Invoker cannot be null");
        }
        if (transactionManager == null) {
            throw new IllegalArgumentException("Transaction manager cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        this.invoker = invoker;
        this.timerPersistence = timerPersistence;
        this.transactionManager = transactionManager;
        this.executorService = executor;
        this.timer = timer;
    }

    public javax.ejb.Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createCalendarTimer(schedule, null);
    }

    public javax.ejb.Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        Serializable info = timerConfig == null ? null : timerConfig.getInfo();
        boolean persistent = timerConfig == null || timerConfig.isPersistent();
        return this.createCalendarTimer(schedule, info, persistent, null);
    }

    public javax.ejb.Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration cannot be null while creating a timer");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration.getTime() cannot be negative while creating a timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration cannot be negative while creating a timer");
        }
        return this.createTimer(initialExpiration, intervalDuration, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initialDuration cannot be negative while creating interval timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration cannot be negative while creating interval timer");
        }
        return this.createIntervalTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, timerConfig);
    }

    public javax.ejb.Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration cannot be null while creating a single action timer");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a single action timer");
        }
        return this.createTimer(expiration, 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration cannot be negative while creating single action timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Duration cannot negative while creating the timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, info, true);
    }

    public javax.ejb.Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("Expiration date cannot be null while creating a timer");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a timer");
        }
        return this.createTimer(expiration, 0L, info, true);
    }

    public javax.ejb.Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("Initial duration cannot be negative while creating timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("Interval cannot be negative while creating timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info, true);
    }

    public javax.ejb.Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("intial expiration date cannot be null while creating a timer");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration cannot be negative while creating timer");
        }
        return this.createTimer(initialExpiration, intervalDuration, info, true);
    }

    public Timer loadAutoTimer(ScheduleExpression schedule, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, null, true, timeoutMethod);
    }

    public Timer loadAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, timerConfig.getInfo(), timerConfig.isPersistent(), timeoutMethod);
    }

    public Collection<javax.ejb.Timer> getTimers() throws IllegalStateException, EJBException {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw new IllegalStateException("getTimers() method invocation is not allowed during lifecycle callback of non-singleton EJBs");
        }
        HashSet<javax.ejb.Timer> activeTimers = new HashSet<javax.ejb.Timer>();
        for (TimerImpl timer : this.nonPersistentTimers.values()) {
            if (timer == null || !timer.isActive()) continue;
            activeTimers.add((javax.ejb.Timer)timer);
        }
        for (TimerImpl timer : this.persistentWaitingOnTxCompletionTimers.values()) {
            if (timer == null || !timer.isActive()) continue;
            activeTimers.add((javax.ejb.Timer)timer);
        }
        activeTimers.addAll(this.getActiveTimers());
        return activeTimers;
    }

    private javax.ejb.Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info, boolean persistent) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw new IllegalStateException("Creation of timers is not allowed during lifecycle callback of non-singleton EJBs");
        }
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initial expiration is null");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        UUID uuid = UUID.randomUUID();
        TimerImpl timer = new TimerImpl(uuid.toString(), this, initialExpiration, intervalDuration, info, persistent);
        if (persistent) {
            this.persistTimer(timer);
        }
        this.startTimer(timer);
        this.addTimer(timer);
        return timer;
    }

    private Timer createCalendarTimer(ScheduleExpression schedule, Serializable info, boolean persistent, Method timeoutMethod) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw new IllegalStateException("Creation of timers is not allowed during lifecycle callback of non-singleton EJBs");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("schedule is null");
        }
        CalendarBasedTimeout calendarTimeout = new CalendarBasedTimeout(schedule);
        UUID uuid = UUID.randomUUID();
        CalendarTimer timer = new CalendarTimer(uuid.toString(), this, calendarTimeout, info, persistent, timeoutMethod);
        if (persistent) {
            this.persistTimer(timer);
        }
        this.startTimer(timer);
        this.addTimer(timer);
        return timer;
    }

    protected void addTimer(TimerImpl timer) {
        if (!timer.persistent) {
            this.nonPersistentTimers.put(timer.getTimerHandle(), timer);
        } else {
            this.persistentWaitingOnTxCompletionTimers.put(timer.getTimerHandle(), timer);
        }
    }

    public TimedObjectInvoker getInvoker() {
        return this.invoker;
    }

    public Timer getTimer(TimerHandle handle) {
        TimerImpl timer = this.nonPersistentTimers.get(handle);
        if (timer != null) {
            return timer;
        }
        timer = this.persistentWaitingOnTxCompletionTimers.get(handle);
        if (timer != null) {
            return timer;
        }
        TimerHandleImpl timerHandle = (TimerHandleImpl)handle;
        return this.getPersistedTimer(timerHandle);
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    void removeTimer(TimerImpl timer) {
        if (!timer.persistent) {
            this.nonPersistentTimers.remove(timer.getTimerHandle());
        } else {
            this.persistentWaitingOnTxCompletionTimers.remove(timer.getTimerHandle());
            this.timerPersistence.removeTimer(timer.getPersistentState());
        }
    }

    public void persistTimer(TimerImpl timer) {
        if (timer == null || !timer.persistent) {
            return;
        }
        TimerEntity timerEntity = timer.getPersistentState();
        try {
            if (this.timerPersistence == null) {
                logger.warn((Object)"Timer persistence is not enabled, persistent timers will not survive JVM restarts");
                return;
            }
            if (timerEntity.getTimerState() == TimerState.EXPIRED || timerEntity.getTimerState() == TimerState.CANCELED) {
                this.timerPersistence.removeTimer(timerEntity);
            } else {
                this.timerPersistence.persistTimer(timerEntity);
            }
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            throw new RuntimeException(t);
        }
    }

    public void suspendTimers() {
        Collection<javax.ejb.Timer> timers = this.getTimers();
        for (javax.ejb.Timer timer : timers) {
            if (!(timer instanceof TimerImpl)) continue;
            ((TimerImpl)timer).suspend();
        }
    }

    public void restoreTimers(List<ScheduleTimer> autoTimers) {
        List<TimerImpl> restorableTimers = this.getActiveTimers();
        LinkedList<ScheduleTimer> newAutoTimers = new LinkedList<ScheduleTimer>(autoTimers);
        logger.debug((Object)("Found " + restorableTimers.size() + " active timers for timedObjectId: " + this.invoker.getTimedObjectId()));
        for (TimerImpl activeTimer : restorableTimers) {
            if (activeTimer.isAutoTimer()) {
                boolean found = false;
                CalendarTimerEntity entity = (CalendarTimerEntity)activeTimer.getPersistentState();
                ListIterator it = newAutoTimers.listIterator();
                while (it.hasNext()) {
                    ScheduleTimer timer = (ScheduleTimer)it.next();
                    String methodName = timer.getMethod().getName();
                    String[] params = new String[timer.getMethod().getParameterTypes().length];
                    for (int i = 0; i < timer.getMethod().getParameterTypes().length; ++i) {
                        params[i] = timer.getMethod().getParameterTypes()[i].getName();
                    }
                    if (!this.doesTimeoutMethodMatch(entity.getTimeoutMethod(), methodName, params) || !this.doesScheduleMatch(entity.getScheduleExpression(), timer.getScheduleExpression())) continue;
                    it.remove();
                    found = true;
                    break;
                }
                if (found) {
                    this.startTimer(activeTimer);
                    logger.debug((Object)("Started timer: " + activeTimer));
                    this.persistTimer(activeTimer);
                } else {
                    this.removeTimer(activeTimer);
                }
            }
            this.startTimer(activeTimer);
            logger.debug((Object)("Started timer: " + activeTimer));
            this.persistTimer(activeTimer);
        }
        for (ScheduleTimer timer : newAutoTimers) {
            this.loadAutoTimer(timer.getScheduleExpression(), timer.getTimerConfig(), timer.getMethod());
        }
    }

    protected void startTimer(TimerImpl timer) {
        this.registerTimerWithTx(timer);
        this.startInTx(timer);
    }

    protected void registerTimerWithTx(TimerImpl timer) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            try {
                tx.registerSynchronization((Synchronization)new TimerCreationTransactionSynchronization(timer));
            }
            catch (RollbackException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (SystemException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
    }

    protected void startInTx(TimerImpl timer) {
        timer.setTimerState(TimerState.ACTIVE);
        this.persistTimer(timer);
        if (this.getTransaction() == null) {
            timer.scheduleTimeout();
        }
    }

    protected boolean isLifecycleCallbackInvocation() {
        InvocationContext currentInvocationContext = null;
        try {
            currentInvocationContext = CurrentInvocationContext.get();
        }
        catch (IllegalStateException ise) {
            return false;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        return invokedMethod == null;
    }

    protected void scheduleTimeout(TimerImpl timer) {
        long intervalDuration;
        Date nextExpiration = timer.getNextExpiration();
        if (nextExpiration == null) {
            logger.info((Object)("Next expiration is null. No tasks will be scheduled for timer " + timer));
            return;
        }
        TimerTask<?> timerTask = timer.getTimerTask();
        long delay = nextExpiration.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        if ((intervalDuration = timer.getInterval()) > 0L) {
            logger.debug((Object)("Scheduling timer " + timer + " at fixed rate, starting at " + delay + " milli seconds from now with repeated interval=" + intervalDuration));
            Task task = new Task(timerTask);
            this.timer.scheduleAtFixedRate((java.util.TimerTask)task, delay, intervalDuration);
            this.scheduledTimerFutures.put(timer.getTimerHandle(), task);
        } else {
            logger.debug((Object)("Scheduling a single action timer " + timer + " starting at " + delay + " milli seconds from now"));
            this.timer.schedule((java.util.TimerTask)new Task(timerTask), delay);
            Task task = new Task(timerTask);
            this.scheduledTimerFutures.put(timer.getTimerHandle(), task);
        }
    }

    protected void cancelTimeout(TimerImpl timer) {
        TimerHandle handle = timer.getTimerHandle();
        java.util.TimerTask timerTask = this.scheduledTimerFutures.get(handle);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private boolean isSingletonBeanInvocation() {
        InvocationContext currentInvocationContext = null;
        try {
            currentInvocationContext = CurrentInvocationContext.get();
            return true;
        }
        catch (IllegalStateException ise) {
            return true;
        }
    }

    private TimerImpl getPersistedTimer(TimerHandleImpl timerHandle) {
        String id = timerHandle.getId();
        String timedObjectId = timerHandle.getTimedObjectId();
        if (this.timerPersistence == null) {
            return null;
        }
        TimerEntity timerEntity = this.timerPersistence.loadTimer(id, timedObjectId);
        if (timerEntity.isCalendarTimer()) {
            return new CalendarTimer((CalendarTimerEntity)timerEntity, this);
        }
        return new TimerImpl(timerEntity, this);
    }

    private List<TimerImpl> getActiveTimers() {
        String timedObjectId = this.getInvoker().getTimedObjectId();
        HashSet<TimerState> ineligibleTimerStates = new HashSet<TimerState>();
        ineligibleTimerStates.add(TimerState.CANCELED);
        ineligibleTimerStates.add(TimerState.EXPIRED);
        if (this.timerPersistence == null) {
            return Collections.emptyList();
        }
        List<TimerEntity> persistedTimers = this.timerPersistence.loadActiveTimers(timedObjectId);
        ArrayList<TimerImpl> activeTimers = new ArrayList<TimerImpl>();
        for (TimerEntity persistedTimer : persistedTimers) {
            if (ineligibleTimerStates.contains((Object)persistedTimer.getTimerState())) continue;
            TimerImpl activeTimer = null;
            if (persistedTimer.isCalendarTimer()) {
                CalendarTimerEntity calendarTimerEntity = (CalendarTimerEntity)persistedTimer;
                activeTimer = new CalendarTimer(calendarTimerEntity, this);
            } else {
                activeTimer = new TimerImpl(persistedTimer, this);
            }
            activeTimers.add(activeTimer);
        }
        return activeTimers;
    }

    private Serializable clone(Serializable info) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(info);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object clonedInfo = objectInputStream.readObject();
        return (Serializable)clonedInfo;
    }

    private boolean doesTimeoutMethodMatch(TimeoutMethod timeoutMethod, String timeoutMethodName, String[] methodParams) {
        if (!timeoutMethod.getMethodName().equals(timeoutMethodName)) {
            return false;
        }
        String[] timeoutMethodParams = timeoutMethod.getMethodParams();
        if (timeoutMethodParams == null && methodParams == null) {
            return true;
        }
        return this.methodParamsMatch(timeoutMethodParams, methodParams);
    }

    private boolean doesScheduleMatch(ScheduleExpression expression1, ScheduleExpression expression2) {
        if (!this.same(expression1.getDayOfMonth(), expression2.getDayOfMonth())) {
            return false;
        }
        if (!this.same(expression1.getDayOfWeek(), expression2.getDayOfWeek())) {
            return false;
        }
        if (!this.same(expression1.getEnd(), expression2.getEnd())) {
            return false;
        }
        if (!this.same(expression1.getHour(), expression2.getHour())) {
            return false;
        }
        if (!this.same(expression1.getMinute(), expression2.getMinute())) {
            return false;
        }
        if (!this.same(expression1.getMonth(), expression2.getMonth())) {
            return false;
        }
        if (!this.same(expression1.getSecond(), expression2.getSecond())) {
            return false;
        }
        if (!this.same(expression1.getStart(), expression2.getStart())) {
            return false;
        }
        if (!this.same(expression1.getTimezone(), expression2.getTimezone())) {
            return false;
        }
        return this.same(expression1.getYear(), expression2.getYear());
    }

    private boolean same(Object i1, Object i2) {
        if (i1 == null && i2 != null) {
            return false;
        }
        if (i2 == null && i1 != null) {
            return false;
        }
        if (i1 == null && i2 == null) {
            return true;
        }
        return i1.equals(i2);
    }

    private boolean isEitherParamNull(Object param1, Object param2) {
        if (param1 != null && param2 == null) {
            return true;
        }
        return param2 != null && param1 == null;
    }

    private boolean methodParamsMatch(String[] methodParams, String[] otherMethodParams) {
        if (this.isEitherParamNull(methodParams, otherMethodParams)) {
            return false;
        }
        if (methodParams.length != otherMethodParams.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].equals(otherMethodParams[i])) continue;
            return false;
        }
        return true;
    }

    private void setRollbackOnly() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"Ignoring exception during setRollbackOnly: ", (Throwable)ise);
        }
        catch (SystemException se) {
            logger.error((Object)"Ignoring exception during setRollbackOnly: ", (Throwable)se);
        }
    }

    private void startNewTx() {
        try {
            this.transactionManager.begin();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start transaction", t);
        }
    }

    private void endTx() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Transaction cannot be ended since no transaction is in progress");
            }
            if (tx.getStatus() == 1) {
                this.transactionManager.rollback();
            } else if (tx.getStatus() == 0) {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not end transaction", e);
        }
    }

    private class Task
    extends java.util.TimerTask {
        private final Runnable delegate;

        public Task(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            TimerServiceImpl.this.executorService.submit(this.delegate);
        }
    }

    private class TimerCreationTransactionSynchronization
    implements Synchronization {
        private TimerImpl timer;

        public TimerCreationTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw new IllegalStateException("Timer cannot be null");
            }
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            TimerState timerState;
            if (this.timer.persistent) {
                Map map = TimerServiceImpl.this.persistentWaitingOnTxCompletionTimers;
                synchronized (map) {
                    TimerServiceImpl.this.persistentWaitingOnTxCompletionTimers.remove(this.timer.getTimerHandle());
                }
            }
            if (status == 3) {
                logger.debug((Object)("commit timer creation: " + this.timer));
                timerState = this.timer.getState();
                switch (timerState) {
                    case ACTIVE: {
                        this.timer.scheduleTimeout();
                    }
                }
            } else if (status == 4) {
                logger.debug((Object)("Rolling back timer creation: " + this.timer));
                timerState = this.timer.getState();
                switch (timerState) {
                    case ACTIVE: {
                        if (this.timer.isPersistent()) {
                            TimerServiceImpl.this.timerPersistence.removeTimer(this.timer.getPersistentState());
                        }
                        this.timer.setTimerState(TimerState.CANCELED);
                    }
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

