/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class OSGiPropertyAdd
implements OperationStepHandler,
DescriptionProvider {
    static final OSGiPropertyAdd INSTANCE = new OSGiPropertyAdd();

    private OSGiPropertyAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        final ModelNode propVal = operation.get("value");
        model.get("value").set(propVal);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String propName = operation.get("address").asObject().get("property").asString();
                    SubsystemState stateService = (SubsystemState)context.getServiceRegistry(true).getRequiredService(SubsystemState.SERVICE_NAME).getValue();
                    Object oldVal = stateService.setProperty(propName, propVal.asString());
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        stateService.setProperty(propName, oldVal);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle resourceBundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(resourceBundle.getString("property.add"));
        OSGiPropertyAdd.addModelProperties(resourceBundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static void addModelProperties(ResourceBundle bundle, ModelNode node, String propType) {
        node.get(new String[]{propType, "value", "description"}).set(bundle.getString("property.value"));
        node.get(new String[]{propType, "value", "type"}).set(ModelType.STRING);
        node.get(new String[]{propType, "value", "required"}).set(true);
    }

    static ModelNode getAddOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("value").set(existing.get("value"));
        return op;
    }
}

